/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.context;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.framework.internal.context.MuleFrameworkServiceConfigurator;
import org.mule.framework.internal.service.ConfigurationPropertiesDelegator;
import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.bootstrap.BootstrapServiceDiscoverer;
import org.mule.runtime.core.api.config.bootstrap.PropertiesBootstrapService;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.api.context.DefaultMuleContextFactory;
import org.mule.runtime.core.api.context.MuleContextBuilder;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.mule.runtime.module.artifact.activation.api.service.config.ContainerServiceConfigurator;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.extension.api.manager.DefaultExtensionManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleFrameworkContextFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleFrameworkContextFactory.class);
    public static final String BOOTSTRAP_PROPERTIES = "META-INF/org/mule/runtime/core/config/registry-bootstrap.properties";
    private MuleFrameworkServiceConfigurator serviceConfigurator;

    public MuleContext createMuleContext(ArtifactType artifactType, List<Service> services, Set<ExtensionModel> extensionModels, ClassLoader classLoader) throws MuleException {
        ConfigurationBuilder baseConfigurationBuilder = ConfigurationBuilder.getMinimalConfigurationBuilder();
        this.serviceConfigurator = new MuleFrameworkServiceConfigurator();
        baseConfigurationBuilder.addServiceConfigurator((ServiceConfigurator)this.serviceConfigurator);
        this.serviceConfigurator.addService("_muleConfigurationAttributesResolver", new ConfigurationPropertiesDelegator());
        return new DefaultMuleContextFactory().createMuleContext(Arrays.asList(this.serviceConfigurationBuilder(services), this.configurationRegistrationConfigurationBuilder(), this.extensionRegistrationConfigurationBuilder(extensionModels), this.bootstrapServiceDiscovererConfigurationBuilder(extensionModels), baseConfigurationBuilder, this.executionClassloaderConfigurationBuilder(classLoader)), MuleContextBuilder.builder((ArtifactType)artifactType));
    }

    private ConfigurationBuilder serviceConfigurationBuilder(final List<Service> services) {
        return new AbstractConfigurationBuilder(){

            protected void doConfigure(MuleContext muleContext) {
                new ContainerServiceConfigurator(services).configure(muleContext.getCustomizationService());
            }
        };
    }

    private ConfigurationBuilder extensionRegistrationConfigurationBuilder(final Set<ExtensionModel> extensionModels) {
        return new AbstractConfigurationBuilder(){

            protected void doConfigure(MuleContext muleContext) {
                DefaultExtensionManagerFactory extensionManagerFactory = new DefaultExtensionManagerFactory();
                ExtensionManager extensionManager = extensionManagerFactory.create(muleContext);
                MuleFrameworkContextFactory.this.serviceConfigurator.addService("_muleExtensionManager", extensionManager);
                extensionModels.forEach(arg_0 -> ((ExtensionManager)extensionManager).registerExtension(arg_0));
            }
        };
    }

    private ConfigurationBuilder configurationRegistrationConfigurationBuilder() {
        return new AbstractConfigurationBuilder(){

            protected void doConfigure(MuleContext muleContext) {
                MuleFrameworkContextFactory.this.serviceConfigurator.addService("_muleConfiguration", muleContext.getConfiguration());
            }
        };
    }

    private ConfigurationBuilder bootstrapServiceDiscovererConfigurationBuilder(Set<ExtensionModel> extensionModels) throws MuleException {
        List classLoaders = extensionModels.stream().map(em -> em.getModelProperty(ClassLoaderModelProperty.class)).filter(Optional::isPresent).map(mp -> ((ClassLoaderModelProperty)mp.get()).getClassLoader()).filter(MuleArtifactClassLoader.class::isInstance).collect(Collectors.toList());
        final ArrayList<PropertiesBootstrapService> bootstrapServices = new ArrayList<PropertiesBootstrapService>();
        for (ClassLoader classLoader : classLoaders) {
            try {
                Enumeration<URL> resources = classLoader.getResources(BOOTSTRAP_PROPERTIES);
                HashSet<URL> fromContainer = new HashSet<URL>(Collections.list(ClassLoaderModelProperty.class.getClassLoader().getResources(BOOTSTRAP_PROPERTIES)));
                while (resources.hasMoreElements()) {
                    URL localResource = resources.nextElement();
                    if (fromContainer.contains(localResource)) continue;
                    LOGGER.debug("Creating PropertiesBootstrapService from properties file: {}", (Object)localResource);
                    Properties properties = new Properties();
                    try (InputStream localResourceStream = localResource.openStream();){
                        properties.load(localResourceStream);
                    }
                    PropertiesBootstrapService pluginBootstrapService = new PropertiesBootstrapService(classLoader, properties);
                    bootstrapServices.add(pluginBootstrapService);
                }
            }
            catch (IOException e) {
                throw new DefaultMuleException((Throwable)e);
            }
        }
        return new AbstractConfigurationBuilder(){

            protected void doConfigure(MuleContext muleContext) {
                BootstrapServiceDiscoverer originalDiscoverer = muleContext.getRegistryBootstrapServiceDiscoverer();
                muleContext.setBootstrapServiceDiscoverer(() -> Stream.concat(originalDiscoverer.discover().stream(), bootstrapServices.stream()).collect(Collectors.toList()));
            }
        };
    }

    private ConfigurationBuilder executionClassloaderConfigurationBuilder(final ClassLoader classLoader) {
        return new AbstractConfigurationBuilder(){

            protected void doConfigure(MuleContext muleContext) {
                muleContext.setExecutionClassLoader(classLoader);
            }
        };
    }
}

