/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.domain;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.framework.internal.builder.configurations.InternalConfigurationsCreationConfigurer;
import org.mule.framework.internal.builder.domain.AbstractFrameworkDomainConfigurer;
import org.mule.framework.internal.builder.domain.DefaultFrameworkDomain;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.api.descriptor.DeployableArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;

public abstract class AbstractFrameworkDomainFromProjectConfigurer
extends AbstractFrameworkDomainConfigurer {
    @Override
    protected DomainDescriptor createDomainDescriptor(Map<String, String> deploymentProperties, Set<URL> folderUrls) {
        DeployableProjectModel model = this.createDeployableProjectModel();
        model.validate();
        try {
            File target;
            for (Path resource : model.getResourcesPath()) {
                folderUrls.add(resource.toUri().toURL());
            }
            if (!model.getPackages().isEmpty() && (target = new File(model.getProjectFolder(), "target/classes")).exists()) {
                folderUrls.add(target.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        return DeployableArtifactDescriptorFactory.defaultArtifactDescriptorFactory().createDomainDescriptor(model, deploymentProperties);
    }

    @Override
    protected DefaultFrameworkDomain getFrameworkDomain(MuleDeployableArtifactClassLoader domainClassLoader, InternalConfigurationsCreationConfigurer configsCreationConfigurer, boolean dslValidations) {
        return new DefaultFrameworkDomain(domainClassLoader, Optional.of(this.createDeployableProjectModel()), configsCreationConfigurer, dslValidations);
    }

    protected abstract DeployableProjectModel createDeployableProjectModel();
}

