/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.mule.framework.api.MuleFramework;
import org.mule.framework.api.execution.MuleExecutionFramework;
import org.mule.framework.api.extension.config.ConfigurationHandler;
import org.mule.framework.api.extension.config.fluent.ConfigurationCreationCommand;
import org.mule.framework.api.tooling.MuleToolingFramework;
import org.mule.framework.internal.builder.application.FrameworkApplication;
import org.mule.framework.internal.builder.artifact.FrameworkDeployableArtifact;
import org.mule.framework.internal.builder.domain.FrameworkDomain;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;

public class DietMuleFrameworkWithExtensionModels
implements MuleFramework {
    private static final String EXT_MODLES_ONLY_MESSAGE_TEMPLATE = "This Mule Framework is meant for analyzing a Mule %ss' extension models only";
    private final FrameworkDeployableArtifact frameworkDeployableArtifact;
    private final Set<ExtensionModel> extensionModels;

    public DietMuleFrameworkWithExtensionModels(FrameworkDeployableArtifact frameworkDeployableArtifact, Set<ExtensionModel> extensionModels) {
        this.frameworkDeployableArtifact = frameworkDeployableArtifact;
        this.extensionModels = extensionModels;
    }

    public Optional<ExtensionModel> getExtensionModel(String name) {
        return this.extensionModels.stream().filter(em -> em.getName().equals(name)).findAny();
    }

    public Set<ExtensionModel> getExtensionModels() {
        return this.extensionModels;
    }

    public Optional<DeployableProjectModel> getDeployableProjectModel() {
        return this.frameworkDeployableArtifact.getDeployableProjectModel();
    }

    public Optional<ArtifactAst> getArtifactAst() {
        throw new UnsupportedOperationException(String.format(EXT_MODLES_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    public Stream<ComponentAst> getConfigsAst() {
        throw new UnsupportedOperationException(String.format(EXT_MODLES_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    public ConfigurationHandler createExtensionConfiguration(String extensionName, String configModelName, Consumer<ConfigurationCreationCommand> command) {
        throw new UnsupportedOperationException(String.format(EXT_MODLES_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    public DslSyntaxResolver getDslSyntaxResolver(ExtensionModel extensionModel) {
        throw new UnsupportedOperationException(String.format(EXT_MODLES_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    public MuleToolingFramework getToolingFramework() {
        throw new UnsupportedOperationException(String.format(EXT_MODLES_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    public MuleExecutionFramework getExecutionFramework() {
        throw new UnsupportedOperationException(String.format(EXT_MODLES_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    public <T> T onExecutionClassLoader(Callable<T> task) throws Exception {
        throw new UnsupportedOperationException(String.format(EXT_MODLES_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    public void onExecutionClassLoader(Runnable task) {
        throw new UnsupportedOperationException(String.format(EXT_MODLES_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    public TypedValue evaluateExpression(String expression, BindingContext bindingContext) {
        throw new UnsupportedOperationException(String.format(EXT_MODLES_ONLY_MESSAGE_TEMPLATE, this.getDeployableArtifactType()));
    }

    private String getDeployableArtifactType() {
        if (this.frameworkDeployableArtifact instanceof FrameworkApplication) {
            return "application";
        }
        if (this.frameworkDeployableArtifact instanceof FrameworkDomain) {
            return "domain";
        }
        return "deployable artifact";
    }

    public void close() throws Exception {
        this.frameworkDeployableArtifact.dispose();
    }
}

