/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.boot.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DefaultMuleClassPathConfig {
    private static final String JAVA_RUNNING_VERSION = "java.specification.version";
    protected static final String MULE_DIR = "/lib/mule";
    protected static final String MULE_JAVA_SPECIFIC_DIR = "/lib/mule/jdk-%s";
    protected static final String USER_DIR = "/lib/user";
    protected static final String OPT_DIR = "/lib/opt";
    protected static final String OPT_JAVA_SPECIFIC_DIR = "/lib/opt/jdk-%s";
    protected List<URL> muleUrls = new ArrayList<URL>();
    protected List<URL> optUrls = new ArrayList<URL>();
    protected List<URL> resourceUrls = new ArrayList<URL>();

    public DefaultMuleClassPathConfig(File muleHome, File muleBase) {
        this.init(muleHome, muleBase);
    }

    protected void init(File muleHome, File muleBase) {
        String optJdkSpecificDir;
        this.addMuleBaseUserLibs(muleHome, muleBase);
        this.addLibraryDirectory(this.muleUrls, muleHome, MULE_DIR);
        this.addLibraryDirectory(this.optUrls, muleHome, USER_DIR);
        this.addLibraryDirectory(this.optUrls, muleHome, OPT_DIR);
        this.addFile(this.resourceUrls, new File(muleHome, USER_DIR));
        String javaSpecVersion = System.getProperty(JAVA_RUNNING_VERSION).split("\\.")[0];
        String muleJdkSpecificDir = String.format(MULE_JAVA_SPECIFIC_DIR, javaSpecVersion);
        if (new File(muleHome, muleJdkSpecificDir).exists()) {
            this.addLibraryDirectory(this.muleUrls, muleHome, muleJdkSpecificDir);
        }
        if (new File(muleHome, optJdkSpecificDir = String.format(OPT_JAVA_SPECIFIC_DIR, javaSpecVersion)).exists()) {
            this.addLibraryDirectory(this.optUrls, muleHome, optJdkSpecificDir);
        }
    }

    protected void addMuleBaseUserLibs(File muleHome, File muleBase) {
        try {
            if (!muleHome.getCanonicalFile().equals(muleBase.getCanonicalFile())) {
                File userOverrideDir = new File(muleBase, USER_DIR);
                this.addFile(this.muleUrls, userOverrideDir);
                this.addFiles(this.muleUrls, this.listJars(userOverrideDir));
            }
        }
        catch (IOException ioe) {
            System.out.println("Unable to check to see if there are local jars to load: " + ioe.toString());
        }
    }

    protected void addLibraryDirectory(List<URL> urls, File muleHome, String libDirectory) {
        File directory = new File(muleHome, libDirectory);
        this.addFile(urls, directory);
        this.addFiles(urls, this.listJars(directory));
    }

    public List<URL> getMuleURLs() {
        return new ArrayList<URL>(this.muleUrls);
    }

    public List<URL> getOptURLs() {
        return new ArrayList<URL>(this.optUrls);
    }

    public List<URL> getResourceURLs() {
        return new ArrayList<URL>(this.resourceUrls);
    }

    public void addURL(List<URL> urls, URL url) {
        urls.add(url);
    }

    public void addFiles(List<URL> urls, List<File> files) {
        for (File file : files) {
            this.addFile(urls, file);
        }
    }

    public void addFile(List<URL> urls, File jar) {
        try {
            this.addURL(urls, jar.getAbsoluteFile().toURI().toURL());
        }
        catch (MalformedURLException mux) {
            throw new RuntimeException("Failed to construct a classpath URL", mux);
        }
    }

    protected List<File> listJars(File path) {
        File[] jars = path.listFiles(pathname -> {
            try {
                return pathname.getCanonicalPath().endsWith(".jar");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        if (jars != null) {
            return Arrays.asList(jars);
        }
        return Collections.emptyList();
    }
}

