/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.security;

import com.hazelcast.internal.networking.HandlerStatus;
import com.hazelcast.internal.networking.OutboundHandler;
import com.hazelcast.internal.nio.IOUtil;
import com.mulesoft.mule.runtime.module.cluster.internal.security.EncryptionUtils;
import java.nio.ByteBuffer;
import org.mule.encryption.Encrypter;
import org.mule.encryption.exception.MuleEncryptionException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;

public class EncrypterHandler
extends OutboundHandler<ByteBuffer, ByteBuffer> {
    public static final int MAX_WRITE_BUFFER_SIZE = 32768;
    public static final int SIZE_OF_INT = 4;
    public static final int MAX_PADDING = 8;
    private final Encrypter encrypter;

    public EncrypterHandler(Encrypter encrypter) {
        this.encrypter = encrypter;
    }

    public void handlerAdded() {
        this.initDstBuffer();
    }

    public synchronized HandlerStatus onWrite() {
        IOUtil.compactOrClear((ByteBuffer)((ByteBuffer)this.dst));
        try {
            if (!((ByteBuffer)this.src).hasRemaining()) {
                HandlerStatus handlerStatus = HandlerStatus.CLEAN;
                return handlerStatus;
            }
            if (((ByteBuffer)this.dst).remaining() < 12) {
                HandlerStatus handlerStatus = HandlerStatus.DIRTY;
                return handlerStatus;
            }
            this.encryptData((ByteBuffer)this.src, (ByteBuffer)this.dst);
            HandlerStatus handlerStatus = ((ByteBuffer)this.src).hasRemaining() ? HandlerStatus.DIRTY : HandlerStatus.CLEAN;
            return handlerStatus;
        }
        catch (MuleEncryptionException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Couldn't encrypt data"), (Throwable)e);
        }
        finally {
            ((ByteBuffer)this.dst).flip();
        }
    }

    private void encryptData(ByteBuffer src, ByteBuffer dst) throws MuleEncryptionException {
        byte[] data = new byte[this.getEncriptableSize(src)];
        src.get(data);
        byte[] encrypted = this.encrypter.encrypt(data);
        dst.putInt(encrypted.length);
        dst.put(encrypted);
    }

    private int getEncriptableSize(ByteBuffer src) {
        int chunkSize = Math.min(32768, ((ByteBuffer)this.dst).remaining());
        if (EncryptionUtils.withPadding(src.remaining()) + 4 > chunkSize) {
            int size = EncryptionUtils.withPadding(chunkSize - 4 - 8) - 1;
            return size;
        }
        return Math.min(32768, src.remaining());
    }
}

