/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.persistence.query;

import com.mulesoft.mule.runtime.module.cluster.api.persistence.query.IdempotentTableNameTransformerStrategy;
import com.mulesoft.mule.runtime.module.cluster.api.persistence.query.TableNameTransformerStrategy;
import com.mulesoft.mule.runtime.module.cluster.internal.persistence.query.DatabaseStoreQueryBuilderStrategy;

public abstract class AbstractDatabaseStoreQueryBuilderStrategy
implements DatabaseStoreQueryBuilderStrategy {
    private TableNameTransformerStrategy tableNameTransformerStrategy;

    public AbstractDatabaseStoreQueryBuilderStrategy(String fileNameTransformerStrategy) {
        this.tableNameTransformerStrategy = AbstractDatabaseStoreQueryBuilderStrategy.getTableNameTransformerStrategy(fileNameTransformerStrategy);
    }

    protected abstract String getCreateTableQueryFormat();

    protected abstract String getStoreQueryFormat();

    protected abstract String getUpdateQueryFormat();

    protected abstract String getLoadQueryFormat();

    protected abstract String getLoadAllQueryFormat();

    protected abstract String getLoadAllKeysQueryFormat();

    protected abstract String getDeleteQueryFormat();

    protected abstract String getDeleteAllQueryFormatWithoutArray();

    protected abstract String getTableExistsQueryFormat() throws UnsupportedOperationException;

    @Override
    public String getCreateTableQuery(String tableName) {
        return String.format(this.getCreateTableQueryFormat(), this.transformTableName(tableName));
    }

    @Override
    public String getStoreQuery(String tableName) {
        return String.format(this.getStoreQueryFormat(), this.transformTableName(tableName));
    }

    @Override
    public String getUpdateQuery(String tableName) {
        return String.format(this.getUpdateQueryFormat(), this.transformTableName(tableName));
    }

    @Override
    public String getLoadQuery(String tableName) {
        return String.format(this.getLoadQueryFormat(), this.transformTableName(tableName));
    }

    @Override
    public String getLoadAllQuery(String tableName, int size) {
        String queryFormat = AbstractDatabaseStoreQueryBuilderStrategy.appendArrayToQueryFormat(this.getLoadAllQueryFormat(), size);
        return String.format(queryFormat, this.transformTableName(tableName));
    }

    @Override
    public String getLoadAllKeysQuery(String tableName) {
        return String.format(this.getLoadAllKeysQueryFormat(), this.transformTableName(tableName));
    }

    @Override
    public String getDeleteQuery(String tableName) {
        return String.format(this.getDeleteQueryFormat(), this.transformTableName(tableName));
    }

    @Override
    public String getDeleteAllQuery(String tableName, int size) {
        String queryFormat = AbstractDatabaseStoreQueryBuilderStrategy.appendArrayToQueryFormat(this.getDeleteAllQueryFormatWithoutArray(), size);
        return String.format(queryFormat, this.transformTableName(tableName));
    }

    @Override
    public String getTableExistsQuery(String tableName) throws UnsupportedOperationException {
        return String.format(this.getTableExistsQueryFormat(), this.transformTableName(tableName));
    }

    @Override
    public String transformTableName(String tableName) {
        return this.tableNameTransformerStrategy.transformTableName(tableName);
    }

    private static String appendArrayToQueryFormat(String formatWithoutArray, int size) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            builder.append("?,");
        }
        return formatWithoutArray + "(" + builder.deleteCharAt(builder.length() - 1).toString() + ")";
    }

    private static TableNameTransformerStrategy getTableNameTransformerStrategy(String fileNameTransformerStrategy) {
        if (fileNameTransformerStrategy == null) {
            return new IdempotentTableNameTransformerStrategy();
        }
        try {
            Class<?> clazz = Class.forName(fileNameTransformerStrategy);
            return (TableNameTransformerStrategy)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error on creating file name transformer for cluster object store", e);
        }
    }
}

