/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.persistence;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.MapLoaderLifecycleSupport;
import com.hazelcast.map.MapStore;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mulesoft.mule.runtime.module.cluster.internal.persistence.TableNameNormalizer;
import com.mulesoft.mule.runtime.module.cluster.internal.persistence.query.DatabaseStoreQueryBuilderStrategy;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.serialization.SerializationProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcMapStore<T extends Serializable>
implements MapStore<Serializable, T>,
MapLoaderLifecycleSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcMapStore.class);
    private static final String DATA_COLUMN = "value_data";
    private static final String KEY_COLUMN = "value_key";
    private final String tableName;
    protected final DataSource datasource;
    private final SerializationProtocol serializationProtocol;
    private DatabaseStoreQueryBuilderStrategy databaseStoreQueryBuilderStrategy;

    public JdbcMapStore(DataSource datasource, String tableName, DatabaseStoreQueryBuilderStrategy databaseStoreQueryBuilderStrategy, SerializationProtocol serializationProtocol) throws SQLException {
        this.serializationProtocol = serializationProtocol;
        this.tableName = TableNameNormalizer.normalize(tableName);
        this.datasource = datasource;
        this.databaseStoreQueryBuilderStrategy = databaseStoreQueryBuilderStrategy;
        Connection connection = null;
        try {
            connection = this.getNonAutoCommitConnection();
            this.init(connection);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    private void init(Connection connection) throws Exception {
        if (!this.isTablePresent(connection)) {
            this.createTable(connection);
            if (!this.isTablePresent(connection)) {
                String transformedTableName = this.databaseStoreQueryBuilderStrategy.transformTableName(this.tableName);
                throw new IllegalStateException(JdbcMapStore.getUnsupportedTableNameMessage(transformedTableName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTablePresent(Connection connection) throws Exception {
        boolean tableExists = false;
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(this.databaseStoreQueryBuilderStrategy.getTableExistsQuery(this.tableName));
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    tableExists = true;
                }
            }
        }
        catch (UnsupportedOperationException e) {
            block9: {
                try {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    String transformedTableName = this.databaseStoreQueryBuilderStrategy.transformTableName(this.tableName);
                    ResultSet resultSet = databaseMetaData.getTables(null, null, transformedTableName, null);
                    if (!resultSet.next()) break block9;
                    tableExists = true;
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(statement);
                    throw throwable;
                }
            }
            DbUtils.closeQuietly((Statement)statement);
        }
        DbUtils.closeQuietly((Statement)statement);
        return tableExists;
    }

    private void createTable(Connection connection) throws Exception {
        PreparedStatement statement = connection.prepareStatement(this.databaseStoreQueryBuilderStrategy.getCreateTableQuery(this.tableName));
        try {
            statement.execute();
            connection.commit();
        }
        finally {
            DbUtils.closeQuietly((Statement)statement);
        }
    }

    public T load(Serializable key) {
        try {
            return this.doLoad(key);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private T doLoad(Serializable key) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private T getBlobValue(ResultSet resultSet) throws SQLException, IOException {
        InputStream binaryStream = resultSet.getBinaryStream(DATA_COLUMN);
        byte[] bytes = IOUtils.toByteArray((InputStream)binaryStream);
        binaryStream.close();
        return (T)((Serializable)this.serializationProtocol.deserialize(bytes));
    }

    public Map<Serializable, T> loadAll(Collection<Serializable> keys) {
        try {
            return this.doLoadAll(keys);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Serializable, T> doLoadAll(Collection<Serializable> keys) throws Exception {
        Map<Serializable, T> map;
        if (keys.isEmpty()) {
            return new HashMap();
        }
        PreparedStatement statement = null;
        Connection connection = null;
        try {
            connection = this.getNonAutoCommitConnection();
            statement = connection.prepareStatement(this.databaseStoreQueryBuilderStrategy.getLoadAllQuery(this.tableName, keys.size()));
            this.appendKeysToQuery(keys, statement);
            map = this.executeLoadAllKeysQuery(keys, statement);
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(statement);
            DbUtils.closeQuietly((Connection)connection);
            throw throwable;
        }
        DbUtils.closeQuietly((Statement)statement);
        DbUtils.closeQuietly((Connection)connection);
        return map;
    }

    private Map<Serializable, T> executeLoadAllKeysQuery(Collection<Serializable> keys, PreparedStatement loadAllQuery) throws SQLException, IOException {
        try (ResultSet resultSet = loadAllQuery.executeQuery();){
            HashMap<String, T> results = new HashMap<String, T>();
            while (resultSet.next()) {
                if (!keys.contains(resultSet.getString(KEY_COLUMN))) continue;
                results.put(resultSet.getString(KEY_COLUMN), this.getBlobValue(resultSet));
            }
            HashMap<String, T> hashMap = results;
            return hashMap;
        }
    }

    public List<Serializable> loadAllKeys() {
        try {
            return this.doLoadAllKeys();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Loose catch block
     */
    private List<Serializable> doLoadAllKeys() throws Exception {
        ArrayList<Serializable> arrayList;
        ResultSet resultSet;
        Connection connection;
        PreparedStatement statement;
        block9: {
            statement = null;
            connection = null;
            connection = this.getNonAutoCommitConnection();
            statement = connection.prepareStatement(this.databaseStoreQueryBuilderStrategy.getLoadAllKeysQuery(this.tableName));
            resultSet = statement.executeQuery();
            ArrayList<Serializable> results = new ArrayList<Serializable>();
            while (resultSet.next()) {
                results.add((Serializable)((Object)resultSet.getString(KEY_COLUMN)));
            }
            arrayList = results;
            if (resultSet == null) break block9;
            resultSet.close();
        }
        DbUtils.closeQuietly((Statement)statement);
        DbUtils.closeQuietly((Connection)connection);
        return arrayList;
        {
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    DbUtils.closeQuietly(statement);
                    DbUtils.closeQuietly((Connection)connection);
                    throw throwable3;
                }
            }
        }
    }

    public void store(Serializable key, T value) {
        boolean isPresent = this.load(key) == null;
        try {
            if (isPresent) {
                this.doStore(key, value);
            } else {
                this.doUpdate(key, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStore(Serializable key, T value) throws Exception {
        PreparedStatement statement = null;
        Connection connection = null;
        try {
            connection = this.getNonAutoCommitConnection();
            statement = connection.prepareStatement(this.databaseStoreQueryBuilderStrategy.getStoreQuery(this.tableName));
            statement.setString(1, this.keyAsString(key));
            byte[] serializedValue = this.serializationProtocol.serialize(value);
            statement.setBinaryStream(2, (InputStream)new ByteArrayInputStream(serializedValue), serializedValue.length);
            if (statement.executeUpdate() == 0) {
                throw new RuntimeException("Store operation did not affect any row in the database");
            }
            connection.commit();
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(statement);
            DbUtils.closeQuietly((Connection)connection);
            throw throwable;
        }
        DbUtils.closeQuietly((Statement)statement);
        DbUtils.closeQuietly((Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(Serializable key, T value) throws Exception {
        PreparedStatement statement = null;
        Connection connection = null;
        try {
            connection = this.getNonAutoCommitConnection();
            statement = connection.prepareStatement(this.databaseStoreQueryBuilderStrategy.getUpdateQuery(this.tableName));
            byte[] serializedValue = this.serializationProtocol.serialize(value);
            statement.setBinaryStream(1, (InputStream)new ByteArrayInputStream(serializedValue), serializedValue.length);
            statement.setString(2, this.keyAsString(key));
            if (statement.executeUpdate() == 0) {
                throw new RuntimeException("Store operation did not affect any row in the database");
            }
            connection.commit();
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(statement);
            DbUtils.closeQuietly((Connection)connection);
            throw throwable;
        }
        DbUtils.closeQuietly((Statement)statement);
        DbUtils.closeQuietly((Connection)connection);
    }

    public void storeAll(Map<Serializable, T> map) {
        for (Map.Entry<Serializable, T> entry : map.entrySet()) {
            this.store(entry.getKey(), (Serializable)entry.getValue());
        }
    }

    public void delete(Serializable key) {
        try {
            this.doDelete(key);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDelete(Serializable key) throws Exception {
        PreparedStatement statement = null;
        Connection connection = null;
        try {
            connection = this.getNonAutoCommitConnection();
            statement = connection.prepareStatement(this.databaseStoreQueryBuilderStrategy.getDeleteQuery(this.tableName));
            statement.setString(1, this.keyAsString(key));
            statement.executeUpdate();
            connection.commit();
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(statement);
            DbUtils.closeQuietly((Connection)connection);
            throw throwable;
        }
        DbUtils.closeQuietly((Statement)statement);
        DbUtils.closeQuietly((Connection)connection);
    }

    public void deleteAll(Collection<Serializable> collection) {
        try {
            this.doDeleteAll(collection);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDeleteAll(Collection<Serializable> collection) throws Exception {
        PreparedStatement statement = null;
        Connection connection = null;
        try {
            connection = this.getNonAutoCommitConnection();
            statement = connection.prepareStatement(this.databaseStoreQueryBuilderStrategy.getDeleteAllQuery(this.tableName, collection.size()));
            this.appendKeysToQuery(collection, statement);
            statement.executeUpdate();
            connection.commit();
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(statement);
            DbUtils.closeQuietly((Connection)connection);
            throw throwable;
        }
        DbUtils.closeQuietly((Statement)statement);
        DbUtils.closeQuietly((Connection)connection);
    }

    private void appendKeysToQuery(Collection<Serializable> collection, PreparedStatement statement) throws SQLException {
        int index = 1;
        for (Serializable key : collection) {
            statement.setString(index++, this.keyAsString(key));
        }
    }

    public void init(HazelcastInstance hazelcastInstance, Properties properties, String mapName) {
        LOGGER.info("JdbcMapStore lifecycle init: '{}', instance: '{}'", (Object)mapName, (Object)hazelcastInstance.getName());
    }

    public void destroy() {
        LOGGER.info("JdbcMapStore lifecycle destroy");
        if (this.datasource instanceof ComboPooledDataSource) {
            ((ComboPooledDataSource)this.datasource).close();
        }
    }

    static String getUnsupportedTableNameMessage(String tableName) {
        return String.format("The table name '%s' is too long and unsupported by your database vendor. If this is based on the Mule artifact name, the cluster ID or any other configurable attribute, try again after reducing its length. Additionally take into account that you should delete the truncated-name tablethat was created with the '%s' prefix.", tableName, TableNameNormalizer.MULE_TABLE_PREFIX);
    }

    private Connection getNonAutoCommitConnection() throws SQLException {
        Connection connection = this.datasource.getConnection();
        connection.setAutoCommit(false);
        return connection;
    }

    private String keyAsString(Serializable key) {
        if (key instanceof String) {
            return (String)((Object)key);
        }
        throw new IllegalArgumentException("The key should be a String, but an instance of " + key.getClass().getName() + " was found");
    }
}

