/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal;

import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.impl.DefaultNodeExtension;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.networking.InboundHandler;
import com.hazelcast.internal.networking.OutboundHandler;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.ServerContext;
import com.hazelcast.internal.server.tcp.PacketDecoder;
import com.hazelcast.internal.server.tcp.PacketEncoder;
import com.mulesoft.mule.runtime.module.cluster.internal.security.DecrypterHandler;
import com.mulesoft.mule.runtime.module.cluster.internal.security.EncrypterHandler;
import com.mulesoft.mule.runtime.module.cluster.internal.security.NodeSecurityManager;

public class MuleNodeExtension
extends DefaultNodeExtension {
    private final NodeSecurityManager securityManager = new NodeSecurityManager();

    public MuleNodeExtension(Node node) {
        super(node);
    }

    public InboundHandler[] createInboundHandlers(EndpointQualifier qualifier, ServerConnection connection, ServerContext serverContext) {
        PacketDecoder decoder = new PacketDecoder(connection, this.node.nodeEngine.getPacketDispatcher());
        if (this.securityManager.isFipsEnabled()) {
            return new InboundHandler[]{new DecrypterHandler(this.securityManager.getEncrypter()), decoder};
        }
        return new InboundHandler[]{decoder};
    }

    public OutboundHandler[] createOutboundHandlers(EndpointQualifier qualifier, ServerConnection connection, ServerContext serverContext) {
        PacketEncoder encoder = new PacketEncoder();
        if (this.securityManager.isFipsEnabled()) {
            return new OutboundHandler[]{encoder, new EncrypterHandler(this.securityManager.getEncrypter())};
        }
        return new OutboundHandler[]{encoder};
    }
}

