/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.util;

import com.google.common.base.Supplier;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mulesoft.agent.util.ResponseErrorEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.exception.ExceptionUtils;

public class ResponseHelper {
    private Map<Class<? extends Exception>, Response.Status> errorStatusMappings = new HashMap<Class<? extends Exception>, Response.Status>();
    private List<Function<Object, Object>> entityTransformers = new ArrayList<Function<Object, Object>>();
    private Gson gson = new GsonBuilder().create();

    public Response response(Supplier<Object> command) {
        return this.response(command, false);
    }

    public Response response(Supplier<Object> command, boolean verboseErrors) {
        try {
            Object entity = command.get();
            for (Function<Object, Object> transformer : this.entityTransformers) {
                entity = transformer.apply(entity);
            }
            return Response.ok((Object)entity).build();
        }
        catch (Exception e) {
            return this.failure(this.getStatus(e.getClass()), e, verboseErrors);
        }
    }

    public Response failure(Response.Status status, Exception exception, boolean verboseErrors) {
        return this.failure(status, exception.getMessage(), exception, verboseErrors);
    }

    public Response failure(Response.Status status, String message, Exception exception, boolean verboseErrors) {
        ResponseErrorEntity errorEntity = new ResponseErrorEntity();
        errorEntity.setErrorType(exception.getClass().toString());
        errorEntity.setErrorMessage(message);
        if (verboseErrors && exception != null) {
            errorEntity.setErrorDetail(ExceptionUtils.getStackTrace((Throwable)exception));
        }
        return Response.status((Response.Status)status).entity((Object)this.gson.toJson((Object)errorEntity)).build();
    }

    public ResponseHelper addErrorMapping(Class<? extends Exception> exceptionClass, Response.Status status) {
        this.errorStatusMappings.put(exceptionClass, status);
        return this;
    }

    public ResponseHelper addEntityTransformer(Function<Object, Object> transformationFunction) {
        this.entityTransformers.add(transformationFunction);
        return this;
    }

    private Response.Status getStatus(Class<? extends Exception> exceptionClass) {
        return this.errorStatusMappings.getOrDefault(exceptionClass, Response.Status.INTERNAL_SERVER_ERROR);
    }
}

