/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.buffer;

import com.google.inject.Inject;
import com.mulesoft.agent.buffer.Buffer;
import com.mulesoft.agent.buffer.BufferConfiguration;
import com.mulesoft.agent.buffer.BufferFactory;
import com.mulesoft.agent.buffer.BufferType;
import com.mulesoft.agent.buffer.exception.BufferException;
import com.mulesoft.agent.buffer.exception.BufferFlushException;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.PostConfigure;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.handlers.InitializableInternalMessageHandler;
import com.mulesoft.agent.handlers.exception.InitializationException;
import com.mulesoft.agent.services.OnOffSwitch;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BufferedHandler<T extends Serializable>
implements InitializableInternalMessageHandler<T> {
    private static final Logger LOGGER = LogManager.getLogger(BufferedHandler.class);
    private static final int DEFAULT_FLUSH_THREADS_NUMBER = 2;
    private static final String DEFAULT_FILE_PATH = ".mule/agent/buffering/";
    private static final String DEFAULT_FILE_NAME = "buffer-%s";
    private static final String MULE_BASE_SYSTEM_PROPERTY = "mule.base";
    @Configurable(value="false")
    protected boolean enabled;
    protected OnOffSwitch enabledSwitch;
    @Configurable
    protected BufferConfiguration buffer;
    @Inject
    protected BufferFactory<T> bufferFactory;
    protected Buffer<T> bufferImplementation;
    private ExecutorService flushExhaustedThreadExecutor;

    @PostConfigure
    public void postConfigurable() throws AgentEnableOperationException {
        if (this.enabledSwitch == null) {
            this.enabledSwitch = OnOffSwitch.newNullSwitch(this.enabled);
        }
    }

    @Override
    public void initialize() throws InitializationException {
        if (!this.isEnableBuffering()) {
            return;
        }
        if (this.flushExhaustedThreadExecutor != null && this.bufferImplementation != null) {
            LOGGER.debug("Buffer for {} already created, skipping creation.", (Object)this.getClass().getSimpleName());
            return;
        }
        this.flushExhaustedThreadExecutor = Executors.newFixedThreadPool(this.getFlushThreadsNumber());
        if (this.getBuffer().getType() == BufferType.DISK) {
            this.generateDefaultBufferFileName();
        }
        this.bufferImplementation = this.getBufferFactory().buildBuffer(this.getBuffer().getType(), this.getBuffer());
        Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(new Thread(() -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Starting buffering flush thread with flushFrequency=%s and retryCount=%s", this.getFlushFrequency(), this.getRetryCount()));
                LOGGER.debug("Starting buffering flush thread for {} with flushFrequency={} and retryCount={}", (Object)this.getClass().getSimpleName(), (Object)this.getFlushFrequency(), (Object)this.getRetryCount());
            }
            try {
                if (this.getBufferImplementation() != null) {
                    this.flushBuffer();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error in flush thread of buffer for {}. Error was: {}", (Object)this.getClass().getSimpleName(), (Object)e);
            }
        }), 0L, this.getFlushFrequency(), TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isEnabled() {
        return this.enabledSwitch.isEnabled();
    }

    @Override
    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabledSwitch.switchTo(state);
    }

    @Override
    public boolean handle(T message) {
        if (this.isEnabled() && this.canHandle(message)) {
            if (!this.isEnableBuffering()) {
                this.flush(Collections.singleton(message));
            } else {
                if (this.getBufferImplementation() == null) {
                    throw new BufferException(String.format("Buffer %s is not initialized", this.getClass().getSimpleName()));
                }
                this.pushMessage(Collections.singletonList(message));
            }
            return true;
        }
        return false;
    }

    private void generateDefaultBufferFileName() {
        if (this.getBuffer() != null && this.getBuffer().getFilePath() == null) {
            if (System.getProperty(MULE_BASE_SYSTEM_PROPERTY) != null) {
                this.getBuffer().setFilePath(System.getProperty(MULE_BASE_SYSTEM_PROPERTY) + File.separator + DEFAULT_FILE_PATH + String.format(DEFAULT_FILE_NAME, this.getClass().getName()));
            } else {
                this.getBuffer().setFilePath(DEFAULT_FILE_PATH + String.format(DEFAULT_FILE_NAME, this.getClass().getName()));
            }
        }
    }

    private Collection<T> getBufferElements() {
        Collection<T> collection;
        try {
            collection = this.getBufferImplementation().get();
        }
        catch (Exception e) {
            throw new BufferException(String.format("Error trying to get buffer elements for buffer %s. Exception was: %s", this.getClass().getSimpleName(), e));
        }
        return collection;
    }

    private void flushBuffer() {
        if (!this.isEnabled()) {
            LOGGER.debug("The internal handler {} is disabled, skipping the buffering flushing until it's enabled.", (Object)this.getClass().getSimpleName());
            return;
        }
        LOGGER.debug("Attempting to flush buffer for {}", (Object)this.getClass().getSimpleName());
        Collection<T> messages = this.getBufferElements();
        if (messages.isEmpty()) {
            LOGGER.debug("The buffer for {} is empty", (Object)this.getClass().getSimpleName());
            return;
        }
        RetryStrategy retryStrategy = new RetryStrategy(this.getRetryCount());
        while (retryStrategy.retry()) {
            try {
                if (this.flush(messages)) {
                    messages.clear();
                    LOGGER.debug("Buffer for {} flushed successfully", (Object)this.getClass().getSimpleName());
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Error flushing buffer for {}. Exception was {}", (Object)this.getClass().getSimpleName(), (Object)new BufferFlushException("Error trying to flush buffer", e));
            }
            LOGGER.info("Trying to retry flushing on buffer for {}. Remaining attempts: {}", (Object)this.getClass().getSimpleName(), (Object)retryStrategy.getRetryCount());
        }
        if (!this.getBuffer().isDiscardMessagesOnFlushFailure()) {
            LOGGER.debug("Sending messages back to the buffer for {}. Messages size: ", (Object)this.getClass().getSimpleName(), (Object)messages.size());
            this.getBufferImplementation().pushAll(messages);
        } else {
            LOGGER.warn("Buffer for {} is configured to discard messages on flush failure. Discarding {} messages.", (Object)this.getClass().getSimpleName(), (Object)messages.size());
        }
        messages.clear();
    }

    protected abstract boolean canHandle(T var1);

    protected abstract boolean flush(Collection<T> var1);

    private void pushMessage(Collection<T> messages) {
        if (this.isExhausted(messages.size())) {
            LOGGER.debug("buffer for {} is exhausted... triggering action", (Object)this.getClass().getSimpleName());
            if (this.getBuffer().getWhenExhausted() != null) {
                switch (this.getBuffer().getWhenExhausted()) {
                    case FAIL: {
                        LOGGER.debug("Buffer for {} is configured to fail when exhausted... failing", (Object)this.getClass().getSimpleName());
                        throw new BufferException(String.format("The buffer for %s has exceeded the maximum capacity. The message will be discarded. Maximum size: %s", this.getClass().getSimpleName(), this.getBuffer().getMaximumCapacity()));
                    }
                }
                LOGGER.debug("Buffer for {} is configured to flush when exhausted... flushing", (Object)this.getClass().getSimpleName());
                this.flushExhaustedThreadExecutor.execute(this::flushBuffer);
            }
        }
        if (messages.size() > 1) {
            this.getBufferImplementation().pushAll(messages);
        } else {
            this.getBufferImplementation().push((Serializable)messages.toArray()[0]);
        }
    }

    private boolean isExhausted(int numberOfMessages) {
        long bufferSize = this.getBufferImplementation().getSize();
        Integer maximumCapacity = this.getBuffer().getMaximumCapacity();
        LOGGER.debug("Buffer configuration for {}:", (Object)this.getClass().getSimpleName());
        LOGGER.debug("max capacity: {}", (Object)maximumCapacity);
        LOGGER.debug("current buffer size: {}", (Object)bufferSize);
        LOGGER.debug("number of messages to insert: {}", (Object)numberOfMessages);
        return maximumCapacity != null && bufferSize + (long)numberOfMessages >= (long)maximumCapacity.intValue();
    }

    private int getFlushThreadsNumber() {
        return this.getBuffer().getFlushThreadsNumber() != null ? this.getBuffer().getFlushThreadsNumber() : 2;
    }

    public Buffer<T> getBufferImplementation() {
        return this.bufferImplementation;
    }

    public BufferConfiguration getBuffer() {
        return this.buffer;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private Long getFlushFrequency() {
        return this.getBuffer().getFlushFrequency();
    }

    private int getRetryCount() {
        return this.getBuffer().getRetryCount() == null ? 1 : this.getBuffer().getRetryCount();
    }

    protected boolean isEnableBuffering() {
        return this.getBuffer() != null;
    }

    public void setBufferFactory(BufferFactory<T> bufferFactory) {
        this.bufferFactory = bufferFactory;
    }

    public BufferFactory<T> getBufferFactory() {
        return this.bufferFactory;
    }

    class RetryStrategy {
        private int retryCount;

        RetryStrategy(int retryCount) {
            this.retryCount = retryCount;
        }

        public boolean retry() {
            --this.retryCount;
            return this.retryCount >= 0;
        }

        public int getRetryCount() {
            return this.retryCount;
        }
    }
}

