/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleXmlGregorianCalendarSerializer
extends Serializer<XMLGregorianCalendar> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleXmlGregorianCalendarSerializer.class);

    public void write(Kryo kryo, Output output, XMLGregorianCalendar calendar) {
        output.writeInt(calendar.getDay(), false);
        kryo.writeClassAndObject(output, (Object)calendar.getEon());
        kryo.writeClassAndObject(output, (Object)calendar.getFractionalSecond());
        output.writeInt(calendar.getHour(), false);
        output.writeInt(calendar.getMinute(), false);
        output.writeInt(calendar.getMonth(), false);
        output.writeInt(calendar.getSecond(), false);
        output.writeInt(calendar.getTimezone(), false);
        output.writeInt(calendar.getYear(), false);
    }

    public XMLGregorianCalendar read(Kryo kryo, Input input, Class<XMLGregorianCalendar> type) {
        int day = input.readInt(false);
        BigInteger eon = (BigInteger)kryo.readClassAndObject(input);
        BigDecimal fractionalSecond = (BigDecimal)kryo.readClassAndObject(input);
        int hour = input.readInt(false);
        int minute = input.readInt(false);
        int month = input.readInt(false);
        int second = input.readInt(false);
        int timezone = input.readInt(false);
        int year = input.readInt(false);
        BigInteger yearAndEon = BigInteger.valueOf(year);
        if (eon != null) {
            yearAndEon = yearAndEon.add(eon);
        }
        LOGGER.debug("year: {}, month: {}, day: {}, hour: {}, minute: {}, second: {}, fracSec: {}, tz: {}, eon: {}, year+eon: {}", new Object[]{year, month, day, hour, minute, second, fractionalSecond, timezone, eon, yearAndEon});
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(yearAndEon, month, day, hour, minute, second, fractionalSecond, timezone);
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public XMLGregorianCalendar copy(Kryo kryo, XMLGregorianCalendar original) {
        return (XMLGregorianCalendar)original.clone();
    }
}

