/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class MuleUnmodifiableCollectionsSerializer
extends Serializer<Object> {
    public Object read(Kryo kryo, Input input, Class<Object> clazz) {
        int ordinal = input.readInt(true);
        UnmodifiableCollection unmodifiableCollection = UnmodifiableCollection.values()[ordinal];
        Object sourceCollection = kryo.readClassAndObject(input);
        return unmodifiableCollection.create(sourceCollection);
    }

    public void write(Kryo kryo, Output output, Object object) {
        try {
            UnmodifiableCollection unmodifiableCollection = UnmodifiableCollection.valueOfType(object.getClass());
            output.writeInt(unmodifiableCollection.ordinal(), true);
            kryo.writeClassAndObject(output, unmodifiableCollection.getCollection(object));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object copy(Kryo kryo, Object original) {
        try {
            UnmodifiableCollection unmodifiableCollection = UnmodifiableCollection.valueOfType(original.getClass());
            Object sourceCollectionCopy = kryo.copy(unmodifiableCollection.getCollection(original));
            return unmodifiableCollection.create(sourceCollectionCopy);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerSerializers(Kryo kryo) {
        MuleUnmodifiableCollectionsSerializer serializer = new MuleUnmodifiableCollectionsSerializer();
        for (UnmodifiableCollection item : UnmodifiableCollection.values()) {
            kryo.register(item.type, (Serializer)serializer);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum UnmodifiableCollection {
        COLLECTION((Class)Collections.unmodifiableCollection(Arrays.asList("")).getClass()){

            @Override
            public Object getCollection(Object toSerialize) {
                Collection list = (Collection)toSerialize;
                return Arrays.asList(list.toArray());
            }

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableCollection((Collection)sourceCollection);
            }
        }
        ,
        RANDOM_ACCESS_LIST((Class)Collections.unmodifiableList(new ArrayList<E>()).getClass()){

            @Override
            public Object getCollection(Object toSerialize) {
                List list = (List)toSerialize;
                return new ArrayList(list);
            }

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableList((List)sourceCollection);
            }
        }
        ,
        LIST((Class)Collections.unmodifiableList(new LinkedList<E>()).getClass()){

            @Override
            public Object getCollection(Object toSerialize) {
                List list = (List)toSerialize;
                return new LinkedList(list);
            }

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableList((List)sourceCollection);
            }
        }
        ,
        SET((Class)Collections.unmodifiableSet(new HashSet<E>()).getClass()){

            @Override
            public Object getCollection(Object toSerialize) {
                Set set = (Set)toSerialize;
                return new HashSet(set);
            }

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableSet((Set)sourceCollection);
            }
        }
        ,
        SORTED_SET((Class)Collections.unmodifiableSortedSet(new TreeSet<E>()).getClass()){

            @Override
            public Object getCollection(Object toSerialize) {
                SortedSet sortedSet = (SortedSet)toSerialize;
                return new TreeSet(sortedSet);
            }

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableSortedSet((SortedSet)sourceCollection);
            }
        }
        ,
        MAP((Class)Collections.unmodifiableMap(new HashMap<K, V>()).getClass()){

            @Override
            public Object getCollection(Object toSerialize) {
                Map map = (Map)toSerialize;
                return new HashMap(map);
            }

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableMap((Map)sourceCollection);
            }
        }
        ,
        SORTED_MAP((Class)Collections.unmodifiableSortedMap(new TreeMap<K, V>()).getClass()){

            @Override
            public Object getCollection(Object toSerialize) {
                SortedMap sortedMap = (SortedMap)toSerialize;
                return new TreeMap(sortedMap);
            }

            @Override
            public Object create(Object sourceCollection) {
                return Collections.unmodifiableSortedMap((SortedMap)sourceCollection);
            }
        };

        private final Class<?> type;

        private UnmodifiableCollection(Class<?> type) {
            this.type = type;
        }

        public abstract Object create(Object var1);

        public abstract Object getCollection(Object var1);

        static UnmodifiableCollection valueOfType(Class<?> type) {
            for (UnmodifiableCollection item : UnmodifiableCollection.values()) {
                if (!item.type.equals(type)) continue;
                return item;
            }
            throw new IllegalArgumentException("The type " + String.valueOf(type) + " is not supported.");
        }
    }
}

