/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.external.handlers.metadata;

import com.google.inject.Inject;
import com.mulesoft.agent.configuration.PostConfigure;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.exception.NoSuchApplicationException;
import com.mulesoft.agent.external.handlers.ConfigurableExternalHandler;
import com.mulesoft.agent.services.AgentMetadataService;
import com.mulesoft.agent.services.RuntimeVersionService;
import com.mulesoft.agent.util.ResponseHelper;
import java.util.NoSuchElementException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.persistence.metadata.ComponentResultJsonSerializer;
import org.mule.runtime.extension.api.persistence.metadata.EntityMetadataResultJsonSerializer;
import org.mule.runtime.extension.api.persistence.metadata.MetadataKeysResultJsonSerializer;

@Named(value="com.mulesoft.agent.services.metadata")
@Path(value="/tooling")
@Singleton
public class MetadataRequestHandler
extends ConfigurableExternalHandler {
    private static final String PATH_SEPARATOR = "/";
    private static final String APP_NAME = "applications";
    private static final String DOMAIN_NAME = "domains";
    private static final String COMPONENT_NAME = "components";
    private static final String APP_PATH = "applications/{applications}";
    private static final String DOMAIN_PATH = "domains/{domains}";
    private static final String COMPONENT_PATH = "components/{components:(.*(\\/.*)*)}";
    private static final String METADATA_RESOLVER = "metadata/";
    private static final String ENTITY_RESOLVER = "entities/";
    private static final String KEYS_RESOLVER = "keys/";
    private static final String KEYS_ENTITY_RESOLVER = "entityKeys/";
    private static final String SOURCE = "source";
    private static final String APP_COMPONENT_ID = "applications/{applications}/components/{components:(.*(\\/.*)*)}/";
    private static final String DOMAIN_COMPONENT_ID = "domains/{domains}/components/{components:(.*(\\/.*)*)}/";
    private static final String QUERY_KEY_CANNOT_BE_EMPTY = "Query key cannot be empty";
    private ResponseHelper responseHelper;
    @Inject
    private AgentMetadataService agentMetadataService;
    @Inject
    private RuntimeVersionService runtimeVersionService;

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabledSwitch.switchTo(state);
    }

    public boolean isEnabled() {
        return this.enabledSwitch.isEnabled();
    }

    @PostConfigure
    public void start() {
        this.responseHelper = new ResponseHelper().addErrorMapping(NoSuchApplicationException.class, Response.Status.NOT_FOUND).addErrorMapping(NoSuchElementException.class, Response.Status.NOT_FOUND);
    }

    @GET
    @Path(value="applications/{applications}/components/{components:(.*(\\/.*)*)}/keys/")
    @Produces(value={"application/json"})
    public Response getMetadataKeysApplication(@PathParam(value="applications") String applicationId, @PathParam(value="components") String componentPath, @QueryParam(value="verbose") boolean verbose) {
        return this.responseHelper.response(() -> new MetadataKeysResultJsonSerializer(true).serialize(this.agentMetadataService.getMetadataKeysApplication(applicationId, Location.builderFromStringRepresentation((String)componentPath).build())), verbose);
    }

    @GET
    @Path(value="domains/{domains}/components/{components:(.*(\\/.*)*)}/keys/")
    @Produces(value={"application/json"})
    public Response getMetadataKeysDomain(@PathParam(value="domains") String domainId, @PathParam(value="components") String componentPath, @QueryParam(value="verbose") boolean verbose) {
        return this.responseHelper.response(() -> new MetadataKeysResultJsonSerializer(true).serialize(this.agentMetadataService.getMetadataKeysDomain(domainId, Location.builderFromStringRepresentation((String)componentPath).build())), verbose);
    }

    @GET
    @Path(value="applications/{applications}/components/{components:(.*(\\/.*)*)}/metadata/")
    @Produces(value={"application/json"})
    public Response getOperationMetadata(@PathParam(value="applications") String applicationId, @PathParam(value="components") String componentPath, @QueryParam(value="verbose") boolean verbose, @QueryParam(value="reduced") @DefaultValue(value="false") boolean reduced) {
        Location location = Location.builderFromStringRepresentation((String)componentPath).build();
        if (location.getParts().size() > 2 && ((String)location.getParts().get(1)).equals(SOURCE)) {
            return this.responseHelper.response(() -> {
                MetadataResult metadata = this.agentMetadataService.getSourceMetadata(applicationId, location);
                return this.getSerializer(reduced).serialize(metadata);
            }, verbose);
        }
        return this.responseHelper.response(() -> {
            MetadataResult metadata = this.agentMetadataService.getOperationMetadata(applicationId, location);
            return this.getSerializer(reduced).serialize(metadata);
        }, verbose);
    }

    private ComponentResultJsonSerializer getSerializer(boolean reduced) {
        if (this.runtimeVersionService.supportsReducedTypeSerialization()) {
            return new ComponentResultJsonSerializer(false, reduced);
        }
        return new ComponentResultJsonSerializer(false);
    }

    @GET
    @Path(value="applications/{applications}/components/{components:(.*(\\/.*)*)}/entities/")
    @Produces(value={"application/json"})
    public Response getEntities(@PathParam(value="applications") String applicationId, @PathParam(value="components") String componentPath, @QueryParam(value="entityKey") String entityKey, @QueryParam(value="verbose") boolean verbose) {
        if (StringUtils.isBlank((String)entityKey)) {
            return this.responseHelper.failure(Response.Status.BAD_REQUEST, QUERY_KEY_CANNOT_BE_EMPTY, (Exception)new MetadataResolvingException(QUERY_KEY_CANNOT_BE_EMPTY, FailureCode.INVALID_METADATA_KEY), verbose);
        }
        return this.responseHelper.response(() -> {
            Location location = this.createLocation(componentPath);
            MetadataKey key = MetadataKeyBuilder.newKey((String)entityKey).build();
            MetadataResult metadata = this.agentMetadataService.getEntityMetadata(applicationId, location, key);
            return new EntityMetadataResultJsonSerializer(true).serialize(metadata);
        }, verbose);
    }

    @GET
    @Path(value="applications/{applications}/components/{components:(.*(\\/.*)*)}/entityKeys/")
    @Produces(value={"application/json"})
    public Response getEntityKeys(@PathParam(value="applications") String applicationId, @PathParam(value="components") String componentPath, @QueryParam(value="verbose") boolean verbose) {
        return this.responseHelper.response(() -> {
            MetadataResult metadataKeys = this.agentMetadataService.getEntityKeys(applicationId, this.createLocation(componentPath));
            return new MetadataKeysResultJsonSerializer(true).serialize(metadataKeys);
        }, verbose);
    }

    @DELETE
    @Path(value="/applications/{applications}/cache/{config}")
    @Produces(value={"application/json"})
    public Response disposeCacheApplication(@PathParam(value="applications") String applicationId, @PathParam(value="config") String configName, @QueryParam(value="verbose") boolean verbose) {
        try {
            this.agentMetadataService.disposeCacheApplication(applicationId, configName);
        }
        catch (Exception e) {
            return this.responseHelper.failure(Response.Status.INTERNAL_SERVER_ERROR, e, verbose);
        }
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/domains/{domains}/cache/{config}")
    @Produces(value={"application/json"})
    public Response disposeCacheDomain(@PathParam(value="domains") String domainId, @PathParam(value="config") String configName, @QueryParam(value="verbose") boolean verbose) {
        try {
            this.agentMetadataService.disposeCacheDomain(domainId, configName);
        }
        catch (Exception e) {
            return this.responseHelper.failure(Response.Status.INTERNAL_SERVER_ERROR, e, verbose);
        }
        return Response.ok().build();
    }

    private Location createLocation(String componentPath) {
        return Location.builderFromStringRepresentation((String)componentPath).build();
    }
}

