/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.internal;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.TransactionManagerServices;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadContext {
    private static final Logger log = LoggerFactory.getLogger(ThreadContext.class);
    private volatile BitronixTransaction transaction;
    private volatile int timeout = TransactionManagerServices.getConfiguration().getDefaultTransactionTimeout();
    private final Map<Object, Object> resources = Collections.synchronizedMap(new HashMap());

    public BitronixTransaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(BitronixTransaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("transaction parameter cannot be null");
        }
        if (log.isDebugEnabled()) {
            log.debug("assigning <" + transaction + "> to <" + this + ">");
        }
        this.transaction = transaction;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        if (timeout == 0) {
            int defaultValue = TransactionManagerServices.getConfiguration().getDefaultTransactionTimeout();
            if (log.isDebugEnabled()) {
                log.debug("resetting default timeout of thread context to default value of " + defaultValue + "s");
            }
            this.timeout = defaultValue;
        } else {
            if (log.isDebugEnabled()) {
                log.debug("changing default timeout of thread context to " + timeout + "s");
            }
            this.timeout = timeout;
        }
    }

    public Map<Object, Object> getResources() {
        return this.resources;
    }

    public String toString() {
        return "a ThreadContext with transaction " + this.transaction + ", default timeout " + this.timeout + "s";
    }
}

