/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.operation;

import com.hazelcast.config.PermissionConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.management.operation.AbstractManagementOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class UpdatePermissionConfigOperation
extends AbstractManagementOperation
implements AllowedDuringPassiveState {
    private Set<PermissionConfig> permissionConfigs;

    public UpdatePermissionConfigOperation() {
    }

    public UpdatePermissionConfigOperation(Set<PermissionConfig> permissionConfigs) {
        this.permissionConfigs = permissionConfigs;
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    public void run() throws Exception {
        Node node = ((NodeEngineImpl)this.getNodeEngine()).getNode();
        try {
            node.securityContext.refreshPermissions(this.permissionConfigs);
        }
        catch (IllegalStateException e) {
            throw new RetryableHazelcastException("Permission refresh was not allowed at this time", e);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.permissionConfigs.size());
        for (PermissionConfig permissionConfig : this.permissionConfigs) {
            permissionConfig.writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int configSize = in.readInt();
        this.permissionConfigs = new HashSet<PermissionConfig>(configSize);
        for (int i = 0; i < configSize; ++i) {
            PermissionConfig permissionConfig = new PermissionConfig();
            permissionConfig.readData(in);
            this.permissionConfigs.add(permissionConfig);
        }
    }
}

