/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.queue;

import java.io.Serializable;
import org.mule.runtime.core.internal.util.queue.QueueStore;
import org.mule.runtime.core.internal.util.queue.QueueStoreCacheListener;

public class CacheAwareQueueStore
implements QueueStore {
    private final QueueStoreCacheListener queueStoreCacheListener;
    private final QueueStore queueStore;

    public CacheAwareQueueStore(QueueStore queueStore, QueueStoreCacheListener queueStoreCacheListener) {
        this.queueStore = queueStore;
        this.queueStoreCacheListener = queueStoreCacheListener;
    }

    @Override
    public String getName() {
        return this.queueStore.getName();
    }

    @Override
    public void putNow(Serializable o) throws InterruptedException {
        this.queueStore.putNow(o);
    }

    @Override
    public boolean offer(Serializable o, int room, long timeout) throws InterruptedException {
        return this.queueStore.offer(o, room, timeout);
    }

    @Override
    public Serializable poll(long timeout) throws InterruptedException {
        return this.queueStore.poll(timeout);
    }

    @Override
    public Serializable peek() throws InterruptedException {
        return this.queueStore.peek();
    }

    @Override
    public void untake(Serializable item) throws InterruptedException {
        this.queueStore.untake(item);
    }

    @Override
    public int getSize() {
        return this.queueStore.getSize();
    }

    @Override
    public void clear() throws InterruptedException {
        this.queueStore.clear();
    }

    @Override
    public void dispose() {
        this.queueStore.dispose();
        this.queueStoreCacheListener.disposeQueueStore(this.queueStore);
    }

    @Override
    public int getCapacity() {
        return this.queueStore.getCapacity();
    }

    @Override
    public void close() {
        this.queueStore.close();
        this.queueStoreCacheListener.closeQueueStore(this.queueStore);
    }

    @Override
    public boolean isPersistent() {
        return this.queueStore.isPersistent();
    }

    QueueStore getDelegate() {
        return this.queueStore;
    }
}

