/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transaction;

import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.runtime.core.privileged.transaction.AbstractTransaction;
import org.mule.runtime.core.privileged.transaction.TransactionAdapter;

public class DelegateTransaction
extends AbstractTransaction {
    private static final Integer DEFAULT_TRANSACTION_TIMEOUT = 30000;
    private static final Optional<TransactionFactory> TX_FACTORY = StreamSupport.stream(ServiceLoader.load(TransactionFactory.class, DelegateTransaction.class.getClassLoader()).spliterator(), false).findFirst();
    private org.mule.runtime.core.api.transaction.Transaction delegate = new NullTransaction();
    private final TransactionManager transactionManager;

    public DelegateTransaction(String applicationName, NotificationDispatcher notificationFirer, TransactionManager transactionManager) {
        super(applicationName, notificationFirer);
        this.transactionManager = transactionManager;
    }

    @Override
    protected void doBegin() {
    }

    @Override
    protected void doCommit() throws TransactionException {
        this.delegate.commit();
    }

    @Override
    protected void doRollback() throws TransactionException {
        this.delegate.rollback();
    }

    @Override
    public int getStatus() throws TransactionException {
        return this.delegate.getStatus();
    }

    @Override
    public boolean isBegun() throws TransactionException {
        return this.delegate.isBegun();
    }

    @Override
    public boolean isRolledBack() throws TransactionException {
        return this.delegate.isRolledBack();
    }

    @Override
    public boolean isCommitted() throws TransactionException {
        return this.delegate.isCommitted();
    }

    @Override
    public Object getResource(Object key) {
        return this.delegate.getResource(key);
    }

    @Override
    public boolean hasResource(Object key) {
        return this.delegate.hasResource(key);
    }

    @Override
    public boolean supports(Object key, Object resource) {
        return this.delegate.supports(key, resource);
    }

    @Override
    public void bindResource(Object key, Object resource) throws TransactionException {
        if (!(this.delegate instanceof NullTransaction)) {
            throw new TransactionException(CoreMessages.createStaticMessage((String)"Single resource transaction has already a resource bound"));
        }
        this.unbindTransaction();
        this.delegate = TX_FACTORY.orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("No %s for transactional resource %s", TransactionFactory.class.getName(), key.getClass().getName())))).beginTransaction(this.applicationName, this.notificationFirer, this.transactionManager);
        this.delegate.setTimeout(this.timeout);
        ((TransactionAdapter)this.delegate).setRollbackIfTimeout(this.rollbackAfterTimeout);
        this.delegate.bindResource(key, resource);
        ((TransactionAdapter)this.delegate).setComponentLocation(this.componentLocation);
    }

    @Override
    public void setRollbackOnly() throws TransactionException {
        this.delegate.setRollbackOnly();
    }

    @Override
    public boolean isRollbackOnly() throws TransactionException {
        return this.delegate.isRollbackOnly();
    }

    @Override
    public boolean isXA() {
        return this.delegate.isXA();
    }

    @Override
    public void resume() throws TransactionException {
        this.delegate.resume();
    }

    @Override
    public Transaction suspend() throws TransactionException {
        return this.delegate.suspend();
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    public boolean supportsInnerTransaction(org.mule.runtime.core.api.transaction.Transaction transaction) {
        return this.delegate instanceof NullTransaction || this.delegate == transaction;
    }

    @Override
    public int getTimeout() {
        return this.delegate.getTimeout();
    }

    @Override
    public void setTimeout(int timeout) {
        super.setTimeout(timeout);
        this.delegate.setTimeout(timeout);
    }

    @Override
    public void setRollbackIfTimeout(boolean rollbackAfterTimeout) {
        super.setRollbackIfTimeout(rollbackAfterTimeout);
        ((TransactionAdapter)this.delegate).setRollbackIfTimeout(rollbackAfterTimeout);
    }

    private class NullTransaction
    implements TransactionAdapter {
        private Integer timeout;

        private NullTransaction() {
        }

        @Override
        public void begin() {
        }

        @Override
        public void commit() throws TransactionException {
        }

        @Override
        public void rollback() throws TransactionException {
        }

        @Override
        public int getStatus() {
            return 5;
        }

        @Override
        public boolean isBegun() {
            return false;
        }

        @Override
        public boolean isRolledBack() {
            return false;
        }

        @Override
        public boolean isCommitted() {
            return false;
        }

        @Override
        public int getTimeout() {
            if (this.timeout != null) {
                return this.timeout;
            }
            this.timeout = DEFAULT_TRANSACTION_TIMEOUT;
            return this.timeout;
        }

        @Override
        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        @Override
        public Object getResource(Object key) {
            return null;
        }

        @Override
        public boolean hasResource(Object key) {
            return false;
        }

        @Override
        public boolean supports(Object key, Object resource) {
            return true;
        }

        @Override
        public void bindResource(Object key, Object resource) {
        }

        @Override
        public void setRollbackOnly() {
        }

        @Override
        public boolean isRollbackOnly() {
            return false;
        }

        @Override
        public boolean isXA() {
            return false;
        }

        @Override
        public void resume() {
        }

        @Override
        public Transaction suspend() {
            return null;
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public Optional<ComponentLocation> getComponentLocation() {
            return Optional.empty();
        }

        @Override
        public void setComponentLocation(ComponentLocation componentLocation) {
        }

        @Override
        public void setRollbackIfTimeout(boolean errorIfTimeout) {
        }
    }
}

