/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.interceptor;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.interception.FlowInterceptorFactory;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.core.internal.interception.DefaultInterceptionEvent;
import org.mule.runtime.core.internal.interception.HasParamsAsTemplateProcessor;
import org.mule.runtime.core.internal.interception.ParametersResolverProcessor;
import org.mule.runtime.core.internal.interception.ReactiveInterceptor;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.processor.interceptor.AbstractInterceptorAdapter;
import org.mule.runtime.core.internal.processor.interceptor.ComponentInterceptorAdapter;
import org.mule.runtime.core.internal.processor.interceptor.ComponentInterceptorFactoryAdapter;
import org.mule.runtime.core.internal.processor.interceptor.DefaultProcessorParameterValue;
import org.mule.runtime.core.internal.processor.interceptor.FlowInterceptorFactoryAdapter;
import org.mule.runtime.core.internal.processor.interceptor.InterceptionException;
import org.mule.runtime.core.internal.processor.interceptor.ProcessorInterceptorFactoryAdapter;
import org.mule.runtime.core.internal.processor.interceptor.ReactiveAroundInterceptorAdapter;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveInterceptorAdapter
extends AbstractInterceptorAdapter
implements ReactiveInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveInterceptorAdapter.class);
    private final ComponentInterceptorFactoryAdapter interceptorFactory;

    public ReactiveInterceptorAdapter(ProcessorInterceptorFactory interceptorFactory) {
        this(new ProcessorInterceptorFactoryAdapter(interceptorFactory));
    }

    public ReactiveInterceptorAdapter(FlowInterceptorFactory interceptorFactory) {
        this(new FlowInterceptorFactoryAdapter(interceptorFactory));
    }

    public ReactiveInterceptorAdapter(ComponentInterceptorFactoryAdapter interceptorFactoryAdapter) {
        this.interceptorFactory = interceptorFactoryAdapter;
    }

    @Override
    public ReactiveProcessor apply(ReactiveProcessor component, ReactiveProcessor next) {
        if (!this.interceptorFactory.isInterceptable(component)) {
            return next;
        }
        ComponentLocation componentLocation = ((Component)component).getLocation();
        if (!this.interceptorFactory.intercept(componentLocation)) {
            return next;
        }
        ComponentInterceptorAdapter interceptor = (ComponentInterceptorAdapter)this.interceptorFactory.get();
        Map dslParameters = (Map)((Component)component).getAnnotation(ComponentAnnotations.ANNOTATION_PARAMETERS);
        ReactiveProcessor interceptedProcessor = this.doApply(component, next, componentLocation, interceptor, dslParameters);
        LOGGER.debug("Interceptor '{}' for processor '{}' configured.", (Object)interceptor, (Object)componentLocation.getLocation());
        return interceptedProcessor;
    }

    protected ReactiveProcessor doApply(ReactiveProcessor component, ReactiveProcessor next, ComponentLocation componentLocation, ComponentInterceptorAdapter interceptor, Map<String, String> dslParameters) {
        if (interceptor.implementsBeforeOrAfter()) {
            LOGGER.debug("Configuring interceptor '{}' before and after processor '{}'...", (Object)interceptor, (Object)componentLocation.getLocation());
            return publisher -> Flux.deferContextual(ctx -> Flux.from((Publisher)publisher).flatMap(event -> Mono.just((Object)event).cast(InternalEvent.class).map(this.doBefore(interceptor, (Component)component, dslParameters)).cast(CoreEvent.class).transform((Function)next).onErrorMap(MessagingException.class, error -> {
                Component failingComponent;
                InternalEvent resolvedEvent = this.doAfter(interceptor, (Component)component, Optional.of(error.getCause())).apply((InternalEvent)error.getEvent());
                Component component2 = failingComponent = error.getFailingComponent() != null ? error.getFailingComponent() : (Component)component;
                if (interceptor.isErrorMappingRequired(componentLocation)) {
                    return this.resolveMessagingException(resolvedEvent, error.getCause(), failingComponent, Optional.of(error));
                }
                return this.createMessagingException(resolvedEvent, error.getCause(), failingComponent, Optional.of(error));
            }).cast(InternalEvent.class).map(this.doAfter(interceptor, (Component)component, Optional.empty())).subscriberContext(innerCtx -> innerCtx.put((Object)"messageProcessors.withinProcessToApply", (Object)true)).onErrorStop()));
        }
        return next;
    }

    protected Function<InternalEvent, InternalEvent> doBefore(ComponentInterceptorAdapter interceptor, Component component, Map<String, String> dslParameters) {
        return event -> {
            InternalEvent eventWithResolvedParams = this.addResolvedParameters((InternalEvent)event, component, dslParameters);
            DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(eventWithResolvedParams);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Calling before() for '{}' in processor '{}'...", (Object)interceptor, (Object)component.getLocation().getLocation());
            }
            try {
                ClassUtils.withContextClassLoader(interceptor.getClassLoader(), () -> interceptor.before(component.getLocation(), this.getResolvedParams(eventWithResolvedParams), interceptionEvent));
                return interceptionEvent.resolve();
            }
            catch (Exception e) {
                if (e.getCause().getCause() instanceof MessagingException) {
                    throw Exceptions.propagate((Throwable)e.getCause().getCause());
                }
                throw Exceptions.propagate((Throwable)((Object)new MessagingException((CoreEvent)interceptionEvent.resolve(), e.getCause(), component)));
            }
        };
    }

    protected Function<InternalEvent, InternalEvent> doAfter(ComponentInterceptorAdapter interceptor, Component component, Optional<Throwable> thrown) {
        return event -> {
            InternalEvent eventWithResolvedParams = this.removeResolvedParameters((InternalEvent)event);
            DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(eventWithResolvedParams);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Calling after() for '{}' in processor '{}'...", (Object)interceptor, (Object)component.getLocation().getLocation());
            }
            try {
                ClassUtils.withContextClassLoader(interceptor.getClassLoader(), () -> interceptor.after(component.getLocation(), interceptionEvent, thrown));
                return interceptionEvent.resolve();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)((Object)this.resolveMessagingException(interceptionEvent.resolve(), e.getCause(), component, Optional.empty())));
            }
        };
    }

    @Override
    protected InternalEvent removeResolvedParameters(InternalEvent event) {
        Processor processor;
        if (this.internalParametersFrom(event).containsKey("core:interceptionResolvedContext") && (processor = (Processor)this.internalParametersFrom(event).get("core:interceptionComponent")) instanceof ParametersResolverProcessor) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Disposing resolved parameters for processor {}...", (Object)((Component)processor).getLocation().getLocation());
            }
            ((ParametersResolverProcessor)((Object)processor)).disposeResolvedParameters((ExecutionContext)this.internalParametersFrom(event).get("core:interceptionResolvedContext"));
        }
        return super.removeResolvedParameters(event);
    }

    @Override
    protected InternalEvent resolveParameters(InternalEvent event, Component component, Map<String, String> parameters) {
        Map resolvedParameters = SmallMap.forSize((int)parameters.size());
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String providedValue = entry.getValue();
            resolvedParameters.put(entry.getKey(), new DefaultProcessorParameterValue(entry.getKey(), providedValue, () -> {
                if (this.expressionManager.isExpression(providedValue)) {
                    if (component instanceof HasParamsAsTemplateProcessor) {
                        return this.expressionManager.parseLogTemplate(providedValue, event, component.getLocation(), BindingContextUtils.NULL_BINDING_CONTEXT);
                    }
                    return this.expressionManager.evaluate(providedValue, (CoreEvent)event, component.getLocation()).getValue();
                }
                return String.valueOf(providedValue);
            }));
        }
        return this.setInternalParamsForNotParamResolver(component, resolvedParameters, event, InternalEvent.builder(event));
    }

    @Override
    protected InternalEvent setInternalParamsForNotParamResolver(Component component, Map<String, ProcessorParameterValue> resolvedParameters, InternalEvent event, InternalEvent.Builder builder) {
        if (component instanceof ParametersResolverProcessor) {
            try {
                ((ParametersResolverProcessor)component).resolveParameters(builder, (params, context) -> {
                    resolvedParameters.putAll(params.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> new DefaultProcessorParameterValue((String)e.getKey(), null, () -> ((Supplier)e.getValue()).get()))));
                    builder.addInternalParameter("core:interceptionResolvedContext", context);
                    builder.addInternalParameter("core:interceptionResolvedParams", resolvedParameters);
                    builder.addInternalParameter("core:interceptionComponent", component);
                });
                return builder.build();
            }
            catch (IllegalArgumentException | ExpressionRuntimeException e) {
                return super.setInternalParamsForNotParamResolver(component, resolvedParameters, event, builder);
            }
            catch (MuleException e) {
                throw new InterceptionException(e);
            }
        }
        return super.setInternalParamsForNotParamResolver(component, resolvedParameters, event, builder);
    }

    public static List<ReactiveInterceptorAdapter> createInterceptors(List<ComponentInterceptorFactoryAdapter> interceptorFactoryAdapters, Injector injector) {
        LinkedList<ReactiveInterceptorAdapter> interceptors = new LinkedList<ReactiveInterceptorAdapter>();
        interceptorFactoryAdapters.stream().forEach(interceptorFactory -> {
            ReactiveInterceptorAdapter reactiveInterceptorAdapter = new ReactiveInterceptorAdapter((ComponentInterceptorFactoryAdapter)interceptorFactory);
            try {
                injector.inject(reactiveInterceptorAdapter);
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
            interceptors.add(0, reactiveInterceptorAdapter);
        });
        interceptorFactoryAdapters.stream().forEach(interceptorFactory -> {
            ReactiveAroundInterceptorAdapter reactiveInterceptorAdapter = new ReactiveAroundInterceptorAdapter((ComponentInterceptorFactoryAdapter)interceptorFactory);
            try {
                injector.inject(reactiveInterceptorAdapter);
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
            interceptors.add(0, reactiveInterceptorAdapter);
        });
        return interceptors;
    }
}

