/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.lifecycle.phases;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.core.internal.lifecycle.phases.LifecycleObjectSorter;

public class DefaultLifecycleObjectSorter
implements LifecycleObjectSorter {
    private List<Object>[] buckets;
    private int objectCount = 0;
    protected Class<?>[] orderedLifecycleTypes;

    public DefaultLifecycleObjectSorter(Class<?>[] orderedLifecycleTypes) {
        this.orderedLifecycleTypes = orderedLifecycleTypes;
        this.buckets = new List[orderedLifecycleTypes.length];
    }

    @Override
    public void addObject(String name, Object object) {
        for (int i = 0; i < this.orderedLifecycleTypes.length; ++i) {
            if (!this.orderedLifecycleTypes[i].isInstance(object)) continue;
            List<Object> bucket = this.buckets[i];
            if (bucket == null) {
                this.buckets[i] = bucket = new LinkedList<Object>();
            }
            this.objectCount += this.doAddObject(name, object, bucket);
            break;
        }
    }

    protected int doAddObject(String name, Object object, List<Object> bucket) {
        bucket.add(object);
        return 1;
    }

    @Override
    public List<Object> getSortedObjects() {
        ArrayList<Object> sorted = new ArrayList<Object>(this.objectCount);
        for (List<Object> bucket : this.buckets) {
            if (bucket == null) continue;
            sorted.addAll(bucket);
        }
        return sorted;
    }
}

