/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.type;

import java.util.List;
import javax.annotation.Nullable;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.nodes.TypeExpressionNode;
import org.raml.v2.internal.impl.commons.type.ResolvedCustomFacets;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.v10.grammar.Raml10Grammar;
import org.raml.v2.internal.impl.v10.rules.TypesUtils;
import org.raml.v2.internal.impl.v10.type.TypeId;
import org.raml.v2.internal.impl.v10.type.TypeVisitor;
import org.raml.v2.internal.impl.v10.type.XmlFacets;
import org.raml.v2.internal.impl.v10.type.XmlFacetsCapableType;
import org.raml.yagi.framework.grammar.rule.AnyOfRule;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.util.NodeSelector;

public class FileResolvedType
extends XmlFacetsCapableType {
    private Integer minLength;
    private Integer maxLength;
    private List<String> fileTypes;

    public FileResolvedType(TypeExpressionNode from) {
        super(FileResolvedType.getTypeName(from, TypeId.FILE.getType()), from, new ResolvedCustomFacets("minLength", "maxLength", "format"));
    }

    public FileResolvedType(String typeName, TypeExpressionNode declarationNode, XmlFacets xmlFacets, Integer minLength, Integer maxLength, List<String> fileTypes, ResolvedCustomFacets customFacets) {
        super(typeName, declarationNode, xmlFacets, customFacets);
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.fileTypes = fileTypes;
    }

    @Override
    protected FileResolvedType copy() {
        return new FileResolvedType(this.getTypeName(), this.getTypeExpressionNode(), this.getXmlFacets().copy(), this.minLength, this.maxLength, this.fileTypes, this.customFacets.copy());
    }

    @Override
    public void validateCanOverwriteWith(TypeDeclarationNode from) {
        this.customFacets.validate(from);
        Raml10Grammar raml10Grammar = new Raml10Grammar();
        AnyOfRule facetRule = new AnyOfRule(new Rule[0]).add((Rule)raml10Grammar.fileTypesField()).add((Rule)raml10Grammar.minLengthField()).add((Rule)raml10Grammar.maxLengthField()).addAll(this.customFacets.getRules());
        TypesUtils.validateAllWith((Rule)facetRule, from.getFacets());
    }

    @Override
    public ResolvedType overwriteFacets(TypeDeclarationNode from) {
        FileResolvedType result = this.copy();
        result.customFacets = this.customFacets.overwriteFacets(from);
        result.setMinLength(NodeSelector.selectIntValue((String)"minLength", (Node)from));
        result.setMaxLength(NodeSelector.selectIntValue((String)"maxLength", (Node)from));
        result.setFileTypes(NodeSelector.selectStringCollection((String)"fileTypes", (Node)from));
        return this.overwriteFacets(result, from);
    }

    @Override
    public ResolvedType mergeFacets(ResolvedType with) {
        FileResolvedType result = this.copy();
        if (with instanceof FileResolvedType) {
            FileResolvedType fileTypeDefinition = (FileResolvedType)with;
            result.setMinLength(fileTypeDefinition.getMinLength());
            result.setMaxLength(fileTypeDefinition.getMaxLength());
            result.setFileTypes(fileTypeDefinition.getFileTypes());
        }
        result.customFacets = result.customFacets.mergeWith(with.customFacets());
        return this.mergeFacets(result, with);
    }

    @Override
    public <T> T visit(TypeVisitor<T> visitor) {
        return visitor.visitFile(this);
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public List<String> getFileTypes() {
        return this.fileTypes;
    }

    public void setFileTypes(List<String> fileTypes) {
        if (fileTypes != null && !fileTypes.isEmpty()) {
            this.fileTypes = fileTypes;
        }
    }

    public void setMinLength(Integer minLength) {
        if (minLength != null) {
            this.minLength = minLength;
        }
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        if (maxLength != null) {
            this.maxLength = maxLength;
        }
    }

    @Override
    @Nullable
    public String getBuiltinTypeName() {
        return TypeId.FILE.getType();
    }
}

