/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsHttpEvent;
import com.mulesoft.mule.runtime.gw.api.analytics.DeploymentType;
import com.mulesoft.mule.runtime.gw.api.analytics.RequestDisposition;
import com.mulesoft.mule.runtime.gw.client.model.HttpEventViews;
import com.mulesoft.mule.runtime.gw.client.model.PolicyViolationDto;
import java.io.Serializable;

@JsonAutoDetect
public class HttpEvent
implements Serializable {
    private static final long serialVersionUID = 8947695862352979432L;
    @JsonProperty(value="api_id")
    private Integer apiId;
    @JsonProperty(value="api_version_id")
    private Long apiVersionId;
    @JsonProperty(value="org_id")
    private String orgId;
    @JsonProperty(value="host_id")
    private String hostId;
    @JsonProperty(value="client_id")
    private String clientId;
    @JsonProperty(value="transaction_id")
    private String transactionId;
    @JsonProperty(value="received_ts")
    private String receivedTs;
    @JsonProperty(value="replied_ts")
    private String repliedTs;
    @JsonProperty(value="client_ip")
    private String clientIp;
    @JsonProperty(value="verb")
    private String verb;
    @JsonProperty(value="path")
    private String path;
    @JsonProperty(value="status_code")
    private int statusCode;
    @JsonProperty(value="user_agent")
    private String userAgent;
    @JsonProperty(value="request_bytes")
    private int requestBytes;
    @JsonProperty(value="response_bytes")
    private int responseBytes;
    @JsonProperty(value="request_disposition")
    private RequestDisposition requestDisposition;
    @JsonProperty(value="policy_violation")
    private PolicyViolationDto policyViolation;
    @JsonProperty(value="api_name")
    @JsonView(value={HttpEventViews.ExternalAnalytics.class})
    private String apiName;
    @JsonProperty(value="api_version")
    @JsonView(value={HttpEventViews.ExternalAnalytics.class})
    private String apiVersion;
    @JsonProperty(value="instance_name")
    @JsonView(value={HttpEventViews.ExternalAnalytics.class})
    private String instanceName;
    @JsonProperty(value="application_name")
    @JsonView(value={HttpEventViews.ExternalAnalytics.class})
    private String applicationName;
    @JsonProperty(value="event_id")
    private String eventId;
    @JsonProperty(value="deployment_type")
    private DeploymentType deploymentType;

    public HttpEvent(Integer apiId, Long apiVersionId, String orgId, String hostId, String clientId, String transactionId, String receivedTs, String repliedTs, String clientIp, String verb, String path, int statusCode, String userAgent, int requestBytes, int responseBytes, RequestDisposition requestDisposition, PolicyViolationDto policyViolation, String apiName, String apiVersion, String instanceName, String applicationName, String eventId, DeploymentType deploymentType) {
        this.apiId = apiId;
        this.apiVersionId = apiVersionId;
        this.orgId = orgId;
        this.hostId = hostId;
        this.clientId = clientId;
        this.transactionId = transactionId;
        this.receivedTs = receivedTs;
        this.repliedTs = repliedTs;
        this.clientIp = clientIp;
        this.verb = verb;
        this.path = path;
        this.statusCode = statusCode;
        this.userAgent = userAgent;
        this.requestBytes = requestBytes;
        this.responseBytes = responseBytes;
        this.requestDisposition = requestDisposition;
        this.policyViolation = policyViolation;
        this.apiName = apiName;
        this.apiVersion = apiVersion;
        this.instanceName = instanceName;
        this.applicationName = applicationName;
        this.eventId = eventId;
        this.deploymentType = deploymentType;
    }

    public static HttpEvent from(AnalyticsHttpEvent event) {
        PolicyViolationDto policyViolationDto = event.getPolicyViolation() != null ? PolicyViolationDto.from(event.getPolicyViolation()) : null;
        return new HttpEvent(event.getApiId(), event.getApiVersionId(), event.getOrgId(), event.getHostId(), event.getClientId(), event.getTransactionId(), event.getReceivedTs(), event.getRepliedTs(), event.getClientIp(), event.getVerb(), event.getPath(), event.getStatusCode(), event.getUserAgent(), event.getRequestBytes(), event.getResponseBytes(), event.getRequestDisposition(), policyViolationDto, event.getApiName(), event.getApiVersion(), event.getInstanceName(), event.getApplicationName(), event.getEventId(), event.getDeploymentType());
    }

    public Integer getApiId() {
        return this.apiId;
    }

    public Long getApiVersionId() {
        return this.apiVersionId;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public String getHostId() {
        return this.hostId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getReceivedTs() {
        return this.receivedTs;
    }

    public String getRepliedTs() {
        return this.repliedTs;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getVerb() {
        return this.verb;
    }

    public String getPath() {
        return this.path;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public int getRequestBytes() {
        return this.requestBytes;
    }

    public int getResponseBytes() {
        return this.responseBytes;
    }

    public RequestDisposition getRequestDisposition() {
        return this.requestDisposition;
    }

    public PolicyViolationDto getPolicyViolation() {
        return this.policyViolation;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public String toString() {
        return "HttpEvent #" + this.hashCode() + "{apiName=" + this.apiName + ", apiVersion=" + this.apiVersion + ", instanceName=" + this.instanceName + ", orgId='" + this.orgId + '\'' + ", hostId='" + this.hostId + '\'' + ", clientId='" + this.clientId + '\'' + ", applicationName='" + this.applicationName + '\'' + ", transactionId='" + this.transactionId + '\'' + ", receivedTs='" + this.receivedTs + '\'' + ", repliedTs='" + this.repliedTs + '\'' + ", clientIp='" + this.clientIp + '\'' + ", verb='" + this.verb + '\'' + ", path='" + this.path + '\'' + ", statusCode=" + this.statusCode + ", userAgent='" + this.userAgent + '\'' + ", requestBytes=" + this.requestBytes + ", responseBytes=" + this.responseBytes + ", requestDisposition=" + this.requestDisposition + ", policyViolation=" + this.policyViolation + ", eventId=" + this.eventId + ", deploymentType=" + this.deploymentType + '}';
    }
}

