/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.function.Function;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.routing.ProcessorRoute;
import org.mule.runtime.core.internal.rx.FluxSinkRecorder;
import reactor.core.publisher.Flux;

class ExecutableRoute {
    private final ProcessorRoute route;
    private final Flux<CoreEvent> publisher;
    private final FluxSinkRecorder<CoreEvent> sinkRecorder;

    ExecutableRoute(ProcessorRoute route) {
        this.route = route;
        this.sinkRecorder = new FluxSinkRecorder();
        this.publisher = this.sinkRecorder.flux().transform((Function)route.getProcessor());
    }

    boolean shouldExecute(ExpressionManagerSession session) {
        return this.route.accepts(session);
    }

    void execute(CoreEvent event) {
        this.sinkRecorder.next((Object)event);
    }

    void error(Throwable throwable) {
        this.sinkRecorder.error(throwable);
    }

    public void complete() {
        this.sinkRecorder.complete();
    }

    public Flux<CoreEvent> getPublisher() {
        return this.publisher;
    }

    public Processor getProcessor() {
        return this.route.getProcessor();
    }
}

