/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.ma.trie.ImmutableHashTrieMap;
import net.sf.saxon.ma.trie.ImmutableMap;
import net.sf.saxon.ma.trie.Tuple2;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeName;

public class LargeAttributeMap
implements AttributeMap {
    private ImmutableHashTrieMap<NodeName, AttributeInfo> attributes;
    private int size;
    private List<AttributeInfo> attributeList = null;
    public static LargeAttributeMap EMPTY = new LargeAttributeMap(new ArrayList<AttributeInfo>(0));

    public LargeAttributeMap(List<AttributeInfo> atts) {
        this.attributeList = atts;
        this.attributes = ImmutableHashTrieMap.empty();
        this.size = atts.size();
        for (AttributeInfo att : atts) {
            if (this.attributes.get(att.getNodeName()) != null) {
                throw new IllegalArgumentException("Attribute map contains duplicates");
            }
            this.attributes = this.attributes.put((Object)att.getNodeName(), (Object)att);
        }
    }

    private LargeAttributeMap(ImmutableHashTrieMap<NodeName, AttributeInfo> attributes, int size) {
        this.attributes = attributes;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public AttributeInfo get(NodeName name) {
        return this.attributes.get(name);
    }

    @Override
    public AttributeInfo get(String uri, String local) {
        FingerprintedQName name = new FingerprintedQName("", uri, local);
        return this.attributes.get(name);
    }

    @Override
    public AttributeInfo getByFingerprint(int fingerprint, NamePool namePool) {
        FingerprintedQName name = new FingerprintedQName(namePool.getStructuredQName(fingerprint), fingerprint);
        return this.attributes.get(name);
    }

    @Override
    public AttributeMap put(AttributeInfo att) {
        ImmutableMap att2 = this.attributes.put((Object)att.getNodeName(), (Object)att);
        int size2 = this.attributes.get(att.getNodeName()) == null ? this.size + 1 : this.size;
        return new LargeAttributeMap((ImmutableHashTrieMap<NodeName, AttributeInfo>)att2, size2);
    }

    @Override
    public AttributeMap remove(NodeName name) {
        if (this.attributes.get(name) == null) {
            return this;
        }
        ImmutableMap att2 = this.attributes.remove((Object)name);
        return new LargeAttributeMap((ImmutableHashTrieMap<NodeName, AttributeInfo>)att2, this.size - 1);
    }

    @Override
    public Iterator<AttributeInfo> iterator() {
        if (this.attributeList != null) {
            return this.attributeList.iterator();
        }
        final Iterator tuples = this.attributes.iterator();
        return new Iterator<AttributeInfo>(){

            @Override
            public boolean hasNext() {
                return tuples.hasNext();
            }

            @Override
            public AttributeInfo next() {
                return (AttributeInfo)((Tuple2)tuples.next())._2;
            }
        };
    }

    @Override
    public synchronized List<AttributeInfo> asList() {
        if (this.attributeList == null) {
            ArrayList<AttributeInfo> list = new ArrayList<AttributeInfo>(this.size);
            this.forEach(list::add);
            this.attributeList = list;
        }
        return new ArrayList<AttributeInfo>(this.attributeList);
    }
}

