/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.proxy;

import org.togglz.core.Feature;
import org.togglz.core.manager.FeatureManager;

public abstract class TogglzSwitchable<T> {
    private final FeatureManager featureManager;
    private final Feature feature;
    private final T active;
    private final T inactive;
    protected T delegate;

    public TogglzSwitchable(FeatureManager featureManager, Feature feature, T active, T inactive) {
        this.featureManager = featureManager;
        this.feature = feature;
        this.active = active;
        this.inactive = inactive;
        this.delegate = featureManager.isActive(feature) ? active : inactive;
    }

    protected final void checkTogglzState() {
        boolean operational;
        boolean configured = this.featureManager.isActive(this.feature);
        boolean bl = operational = this.delegate == this.active;
        if (configured ^ operational) {
            this.delegate = configured ? this.active : this.inactive;
        }
    }

    public static void update(Object o) {
        if (o instanceof TogglzSwitchable) {
            ((TogglzSwitchable)o).checkTogglzState();
        }
    }
}

