/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.span;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.mule.runtime.api.profiling.tracing.Span;
import org.mule.runtime.api.profiling.tracing.SpanDuration;
import org.mule.runtime.api.profiling.tracing.SpanError;
import org.mule.runtime.api.profiling.tracing.SpanIdentifier;
import org.mule.runtime.tracer.api.span.InternalSpan;
import org.mule.runtime.tracer.api.span.error.InternalSpanError;
import org.mule.runtime.tracer.api.span.exporter.SpanExporter;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.mule.runtime.tracer.exporter.api.SpanExporterFactory;
import org.mule.runtime.tracer.impl.clock.Clock;

public class ExecutionSpan
implements InternalSpan {
    public static final String SPAN_KIND = "span.kind.override";
    public static final String STATUS = "status.override";
    private final InitialSpanInfo initialSpanInfo;
    private SpanExporter spanExporter = SpanExporter.NOOP_EXPORTER;
    private SpanError lastError;
    private final InternalSpan parent;
    private final Long startTime;
    private Long endTime;
    private final Map<String, String> additionalAttributes = new HashMap<String, String>();

    public static ExecutionSpanBuilder getExecutionSpanBuilder() {
        return new ExecutionSpanBuilder();
    }

    private ExecutionSpan(InitialSpanInfo initialSpanInfo, Long startTime, InternalSpan parent) {
        this.initialSpanInfo = initialSpanInfo;
        this.startTime = startTime;
        this.parent = parent;
    }

    public Span getParent() {
        return this.parent;
    }

    public SpanIdentifier getIdentifier() {
        return null;
    }

    public String getName() {
        return this.initialSpanInfo.getName();
    }

    public SpanDuration getDuration() {
        return new DefaultSpanDuration(this.startTime, this.endTime);
    }

    public List<SpanError> getErrors() {
        if (this.lastError != null) {
            return Collections.singletonList(this.lastError);
        }
        return Collections.emptyList();
    }

    public void setRootAttribute(String s, String s1) {
        this.spanExporter.setRootAttribute(s, s1);
    }

    public int getAttributesCount() {
        return this.initialSpanInfo.getInitialAttributesCount() + this.additionalAttributes.size();
    }

    public void updateRootName(String name) {
        this.spanExporter.setRootName(name);
    }

    public boolean hasErrors() {
        return this.lastError != null;
    }

    public void end() {
        this.endTime = Clock.getDefault().now();
        this.spanExporter.export();
    }

    public void addError(InternalSpanError error) {
        this.lastError = error;
        this.spanExporter.onError(error);
    }

    public void updateName(String name) {
        this.spanExporter.updateNameForExport(name);
    }

    public SpanExporter getSpanExporter() {
        return this.spanExporter;
    }

    public void forEachAttribute(BiConsumer<String, String> biConsumer) {
        this.initialSpanInfo.forEachAttribute(biConsumer);
        if (!this.additionalAttributes.isEmpty()) {
            this.additionalAttributes.forEach(biConsumer);
        }
    }

    public Map<String, String> serializeAsMap() {
        return this.spanExporter.exportedSpanAsMap();
    }

    public void addAttribute(String key, String value) {
        if (!key.equals(SPAN_KIND) && !key.equals(STATUS)) {
            this.additionalAttributes.put(key, value);
        }
        this.spanExporter.onAdditionalAttribute(key, value);
    }

    public void updateChildSpanExporter(InternalSpan internalSpan) {
        this.spanExporter.updateChildSpanExporter(internalSpan.getSpanExporter());
    }

    public static class ExecutionSpanBuilder {
        public static final String THERE_IS_NO_SPAN_FACTORY_MESSAGE = "there is no span factory";
        private InternalSpan parent;
        private Long startTime;
        private SpanExporterFactory spanExporterFactory;
        private InitialSpanInfo initialSpanInfo;

        private ExecutionSpanBuilder() {
        }

        public ExecutionSpanBuilder withStartSpanInfo(InitialSpanInfo spanCustomizationInfo) {
            this.initialSpanInfo = spanCustomizationInfo;
            return this;
        }

        public ExecutionSpanBuilder withParentSpan(InternalSpan parent) {
            this.parent = parent;
            return this;
        }

        public ExecutionSpanBuilder withSpanExporterFactory(SpanExporterFactory spanExporterFactory) {
            this.spanExporterFactory = spanExporterFactory;
            return this;
        }

        public ExecutionSpan build() {
            if (this.startTime == null) {
                this.startTime = Clock.getDefault().now();
            }
            if (this.spanExporterFactory == null) {
                throw new IllegalArgumentException(THERE_IS_NO_SPAN_FACTORY_MESSAGE);
            }
            ExecutionSpan executionSpan = new ExecutionSpan(this.initialSpanInfo, this.startTime, this.parent);
            executionSpan.spanExporter = this.spanExporterFactory.getSpanExporter((InternalSpan)executionSpan, this.initialSpanInfo);
            return executionSpan;
        }
    }

    private static class DefaultSpanDuration
    implements SpanDuration {
        private final Long startTime;
        private final Long endTime;

        public DefaultSpanDuration(Long startTime, Long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public Long getStart() {
            return this.startTime;
        }

        public Long getEnd() {
            return this.endTime;
        }
    }
}

