/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.random;

import com.opensymphony.module.random.Rijndael_Algorithm;
import java.security.InvalidKeyException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Rijndael {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$module$random$Rijndael == null ? (class$com$opensymphony$module$random$Rijndael = Rijndael.class$("com.opensymphony.module.random.Rijndael")) : class$com$opensymphony$module$random$Rijndael));
    private Object sessionKey;
    private int blocksize;
    private int keysize;
    static /* synthetic */ Class class$com$opensymphony$module$random$Rijndael;

    public Rijndael(int keysize, int blocksize) {
        if (keysize != 128 && keysize != 192 && keysize != 256) {
            throw new RuntimeException("Invalid keysize");
        }
        if (blocksize != 128 && blocksize != 192 && blocksize != 256) {
            throw new RuntimeException("Invalid blocksize");
        }
        this.keysize = keysize;
        this.blocksize = blocksize;
    }

    public Rijndael() {
        this(128, 128);
    }

    public int getBlockSize() {
        return this.blocksize;
    }

    public int getKeySize() {
        return this.keysize;
    }

    public byte[] decipher(byte[] block) {
        return Rijndael_Algorithm.blockDecrypt(block, 0, this.sessionKey);
    }

    public byte[] encipher(byte[] block) {
        return Rijndael_Algorithm.blockEncrypt(block, 0, this.sessionKey);
    }

    public void initialize(byte[] key) {
        try {
            byte[] nkey = new byte[this.keysize >> 3];
            System.arraycopy(key, 0, nkey, 0, nkey.length);
            this.sessionKey = Rijndael_Algorithm.makeKey(nkey);
        }
        catch (InvalidKeyException e) {
            log.error((Object)"Could not initialize properly", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

