/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.tracing.customization.ComponentExecutionInitialSpanInfo;
import org.mule.runtime.core.internal.routing.ExpressionSplittingStrategy;
import org.mule.runtime.core.internal.routing.ForeachContext;
import org.mule.runtime.core.internal.routing.ForeachRouter;
import org.mule.runtime.core.internal.routing.ForeachUtils;
import org.mule.runtime.core.internal.routing.SplittingStrategy;
import org.mule.runtime.core.internal.routing.outbound.EventBuilderConfigurerIterator;
import org.mule.runtime.core.internal.routing.outbound.EventBuilderConfigurerList;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.Scope;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Foreach
extends AbstractMessageProcessorOwner
implements Initialisable,
Scope {
    private static final Logger LOGGER = LoggerFactory.getLogger(Foreach.class);
    static final String DEFAULT_COUNTER_VARIABLE = "counter";
    public static final String DEFAULT_ROOT_MESSAGE_VARIABLE = "rootMessage";
    private String counterVariableName = "counter";
    private String rootMessageVariableName = "rootMessage";
    @Inject
    protected ExpressionManager expressionManager;
    @Inject
    protected StreamingManager streamingManager;
    @Inject
    private FeatureFlaggingService featureFlaggingService;
    private List<Processor> messageProcessors;
    private String expression = "#[payload]";
    private int batchSize = 1;
    private SplittingStrategy<CoreEvent, Iterator<TypedValue<?>>> splittingStrategy;
    private MessageProcessorChain nestedChain;

    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply((CoreEvent)event, (ReactiveProcessor)this);
    }

    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return new ForeachRouter(this, this.streamingManager, publisher, this.expression, this.batchSize, this.nestedChain, this.shouldRejectMapExpressions()).getDownstreamPublisher();
    }

    private boolean shouldRejectMapExpressions() {
        if (this.featureFlaggingService == null) {
            return true;
        }
        return this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.FOREACH_ROUTER_REJECTS_MAP_EXPRESSIONS);
    }

    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.nestedChain);
    }

    public void setMessageProcessors(List<Processor> messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public void initialise() throws InitialisationException {
        Optional processingStrategy = MessageProcessors.getProcessingStrategy((ConfigurationComponentLocator)this.locator, (Component)this);
        this.nestedChain = MessageProcessors.buildNewChainWithListOfProcessors((Optional)processingStrategy, this.messageProcessors, (InitialSpanInfo)new ComponentExecutionInitialSpanInfo((Component)this, ":iteration"));
        this.splittingStrategy = new ExpressionSplittingStrategy(this.expressionManager, this.expression);
        super.initialise();
    }

    public void setCollectionExpression(String expression) {
        this.expression = expression;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public String getRootMessageVariableName() {
        return this.rootMessageVariableName;
    }

    public void setRootMessageVariableName(String rootMessageVariableName) {
        this.rootMessageVariableName = rootMessageVariableName;
    }

    public String getCounterVariableName() {
        return this.counterVariableName;
    }

    public void setCounterVariableName(String counterVariableName) {
        this.counterVariableName = counterVariableName;
    }

    public SplittingStrategy<CoreEvent, Iterator<TypedValue<?>>> getSplittingStrategy() {
        return this.splittingStrategy;
    }

    boolean isMapExpression(CoreEvent event) {
        return this.expression.equals("#[payload]") && Map.class.isAssignableFrom(event.getMessage().getPayload().getDataType().getType());
    }

    Iterator<TypedValue<?>> splitRequest(CoreEvent request, String expression) {
        Object payloadValue = request.getMessage().getPayload().getValue();
        Iterator<TypedValue<?>> result = "#[payload]".equals(expression) && payloadValue instanceof EventBuilderConfigurerList ? Iterators.transform((Iterator)((EventBuilderConfigurerList)payloadValue).eventBuilderConfigurerIterator(), TypedValue::of) : ("#[payload]".equals(expression) && payloadValue instanceof EventBuilderConfigurerIterator ? new EventBuilderConfigurerIteratorWrapper((EventBuilderConfigurerIterator)payloadValue) : (Iterator)this.getSplittingStrategy().split((Object)request));
        if (LOGGER.isDebugEnabled() && !result.hasNext()) {
            LOGGER.debug("<foreach> expression \"{}\" returned no results. If this is not expected please check your expression", (Object)expression);
        }
        return result;
    }

    TypedValue setCurrentValue(int batchSize, ForeachContext foreachContext, CoreEvent event) {
        TypedValue currentValue;
        Iterator<TypedValue<?>> iterator = foreachContext.getIterator();
        if (batchSize > 1) {
            ArrayList<TypedValue> currentBatch = new ArrayList<TypedValue>();
            for (int counter = 0; iterator.hasNext() && counter < batchSize; ++counter) {
                TypedValue managedValue = ForeachUtils.manageTypedValueForStreaming(iterator.next(), event, this.streamingManager);
                currentBatch.add(managedValue);
            }
            if (!foreachContext.getBatchDataType().isPresent()) {
                foreachContext.setBatchDataType(Optional.of(DataType.fromObject(currentBatch)));
            }
            currentValue = new TypedValue(currentBatch, foreachContext.getBatchDataType().get());
        } else {
            currentValue = iterator.next();
        }
        return currentValue;
    }

    private static class EventBuilderConfigurerIteratorWrapper
    implements Iterator<TypedValue<?>> {
        private final EventBuilderConfigurerIterator configurerIterator;

        EventBuilderConfigurerIteratorWrapper(EventBuilderConfigurerIterator configurerIterator) {
            this.configurerIterator = configurerIterator;
        }

        @Override
        public boolean hasNext() {
            return this.configurerIterator.hasNext();
        }

        @Override
        public TypedValue<?> next() {
            return TypedValue.of((Object)this.configurerIterator.nextEventBuilderConfigurer());
        }
    }
}

