/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeType;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class ExclusiveSiblingRule
extends Rule {
    private String value;
    private Set<String> notAllowedSiblings;

    public ExclusiveSiblingRule(String value, Set<String> notAllowedSiblings) {
        this.value = value;
        this.notAllowedSiblings = notAllowedSiblings;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        return Lists.newArrayList();
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        return node instanceof StringNode && ((StringNode)node).getValue().equals(this.value);
    }

    @Override
    @Nonnull
    public Node apply(@Nonnull Node node) {
        if (!(node instanceof StringNode)) {
            return ErrorNodeFactory.createInvalidType(node, NodeType.String);
        }
        if (!this.matches(node)) {
            return ErrorNodeFactory.createInvalidValue(node, this.value);
        }
        if (this.matchesSiblings(node)) {
            return ErrorNodeFactory.createInvalidSiblingsValue(node, this.notAllowedSiblings);
        }
        return this.createNodeUsingFactory(node, ((StringNode)node).getValue());
    }

    private boolean matchesSiblings(Node node) {
        if (node.getParent() == null || node.getParent().getParent() == null) {
            return false;
        }
        Node grandParent = node.getParent().getParent();
        for (String sibling : this.notAllowedSiblings) {
            if (grandParent.get(sibling) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public String getDescription() {
        return "\"" + this.value + "\"";
    }
}

