/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal.processor;

import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.serialization.ArtifactAstDeserializer;
import org.mule.runtime.ast.api.serialization.ArtifactAstSerializerProvider;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.deployment.model.api.artifact.ArtifactConfigurationProcessor;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContextConfiguration;
import org.mule.runtime.module.deployment.internal.processor.AbstractAstConfigurationProcessor;
import org.mule.runtime.module.deployment.internal.processor.AstXmlParserArtifactConfigurationProcessor;
import org.mule.runtime.module.deployment.internal.processor.FallbackAllowedArtifactConfigurationProcessor;
import org.mule.runtime.module.deployment.internal.processor.FallbackArtifactConfigurationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializedAstArtifactConfigurationProcessor
extends AbstractAstConfigurationProcessor
implements FallbackAllowedArtifactConfigurationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FallbackArtifactConfigurationProcessor.class);
    private final ArtifactAstDeserializer defaultArtifactAstDeserializer = new ArtifactAstSerializerProvider().getDeserializer();

    @Override
    public boolean check(ArtifactContextConfiguration artifactContextConfiguration) {
        MuleContext muleContext = artifactContextConfiguration.getMuleContext();
        InputStream seralizedAstStream = muleContext.getExecutionClassLoader().getResourceAsStream("META-INF/mule-artifact/artifact.ast");
        if (seralizedAstStream == null) {
            LOGGER.info("Serialized AST not avaliable for artifact '" + muleContext.getConfiguration().getId() + "'");
        }
        return seralizedAstStream != null;
    }

    @Override
    protected ArtifactAst obtainArtifactAst(ArtifactContextConfiguration artifactContextConfiguration) throws ConfigurationException {
        try {
            MuleContext muleContext = artifactContextConfiguration.getMuleContext();
            return this.defaultArtifactAstDeserializer.deserialize(muleContext.getExecutionClassLoader().getResourceAsStream("META-INF/mule-artifact/artifact.ast"), name -> this.getExtensions(muleContext.getExtensionManager()).stream().filter(x -> x.getName().equals(name)).findFirst().orElse(null));
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    private Set<ExtensionModel> getExtensions(ExtensionManager extensionManager) {
        return extensionManager == null ? Collections.emptySet() : extensionManager.getExtensions();
    }

    public static ArtifactConfigurationProcessor serializedAstWithFallbackArtifactConfigurationProcessor() {
        return new FallbackArtifactConfigurationProcessor(new SerializedAstArtifactConfigurationProcessor(), new AstXmlParserArtifactConfigurationProcessor());
    }
}

