/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apache.xerces.impl.xs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.mule.apache.xerces.impl.dv.ValidatedInfo;
import org.mule.apache.xerces.impl.dv.XSSimpleType;
import org.mule.apache.xerces.impl.xs.AttributePSVImpl;
import org.mule.apache.xerces.impl.xs.ObjectFactory;
import org.mule.apache.xerces.impl.xs.SchemaSymbols;
import org.mule.apache.xerces.impl.xs.SecuritySupport;
import org.mule.apache.xerces.impl.xs.XMLAssertPsychopathXPath2Impl;
import org.mule.apache.xerces.impl.xs.XMLSchemaValidator;
import org.mule.apache.xerces.impl.xs.assertion.XMLAssertHandler;
import org.mule.apache.xerces.impl.xs.assertion.XSAssert;
import org.mule.apache.xerces.impl.xs.assertion.XSAssertConstants;
import org.mule.apache.xerces.impl.xs.assertion.XSAssertImpl;
import org.mule.apache.xerces.impl.xs.util.XS11TypeHelper;
import org.mule.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.mule.apache.xerces.util.AugmentationsImpl;
import org.mule.apache.xerces.util.NamespaceSupport;
import org.mule.apache.xerces.util.XMLAttributesImpl;
import org.mule.apache.xerces.xni.Augmentations;
import org.mule.apache.xerces.xni.QName;
import org.mule.apache.xerces.xni.XMLAttributes;
import org.mule.apache.xerces.xni.XMLString;
import org.mule.apache.xerces.xni.XNIException;
import org.mule.apache.xerces.xs.XSComplexTypeDefinition;
import org.mule.apache.xerces.xs.XSMultiValueFacet;
import org.mule.apache.xerces.xs.XSObjectList;
import org.mule.apache.xerces.xs.XSSimpleTypeDefinition;
import org.mule.apache.xerces.xs.XSTypeDefinition;

public class XSDAssertionValidator {
    XMLSchemaValidator fXmlSchemaValidator = null;
    XMLAssertHandler fAssertionProcessor = null;
    boolean fAttributesHaveAsserts = false;

    public XSDAssertionValidator(XMLSchemaValidator xmlSchemaValidator) {
        this.fXmlSchemaValidator = xmlSchemaValidator;
    }

    public void characterDataHandler(XMLString text) {
        if (this.fAssertionProcessor != null) {
            this.fAssertionProcessor.characters(text);
        }
    }

    public void handleStartElement(QName element, XMLAttributes attributes) throws Exception {
        List assertionList = this.getAssertsForEvaluation(element, attributes);
        if (assertionList != null && this.fAssertionProcessor == null) {
            NamespaceSupport xpathNamespaceContext = null;
            if (assertionList instanceof XSObjectList) {
                xpathNamespaceContext = ((XSAssertImpl)((XSObjectList)assertionList).item(0)).getXPath2NamespaceContext();
            } else {
                Vector assertVector = (Vector)assertionList;
                xpathNamespaceContext = ((XSAssertImpl)assertVector.get(0)).getXPath2NamespaceContext();
            }
            HashMap<String, NamespaceSupport> assertProcessorParams = new HashMap<String, NamespaceSupport>();
            assertProcessorParams.put("XPATH2_NS_CONTEXT", xpathNamespaceContext);
            this.initializeAssertProcessor(assertProcessorParams);
        }
        if (this.fAssertionProcessor != null) {
            AugmentationsImpl assertAugs = new AugmentationsImpl();
            assertAugs.putItem(XSAssertConstants.assertList, assertionList);
            assertAugs.putItem(XSAssertConstants.isAttrHaveAsserts, this.fAttributesHaveAsserts);
            this.fAttributesHaveAsserts = false;
            this.fAssertionProcessor.startElement(element, attributes, assertAugs);
        }
    }

    public void handleEndElement(QName element, Augmentations augs) {
        if (this.fAssertionProcessor != null) {
            try {
                this.fAssertionProcessor.endElement(element, augs);
            }
            catch (Exception ex) {
                throw new XNIException(ex.getMessage(), ex);
            }
        }
    }

    public void comment(XMLString text) {
        if (this.fAssertionProcessor != null) {
            this.fAssertionProcessor.comment(text);
        }
    }

    public void processingInstruction(String target, XMLString data) {
        if (this.fAssertionProcessor != null) {
            this.fAssertionProcessor.processingInstruction(target, data);
        }
    }

    private List getAssertsForEvaluation(QName element, XMLAttributes attributes) {
        List assertionList = null;
        XSTypeDefinition typeDefn = this.fXmlSchemaValidator.fCurrentPSVI.getTypeDefinition();
        if (typeDefn != null) {
            if (typeDefn.getTypeCategory() == 15) {
                XSObjectListImpl complexTypeAsserts = this.getAssertsFromComplexType((XSComplexTypeDefinition)typeDefn, attributes);
                if (complexTypeAsserts.size() > 0) {
                    assertionList = complexTypeAsserts;
                }
            } else {
                assertionList = this.getAssertsFromSimpleType((XSSimpleTypeDefinition)typeDefn);
            }
        }
        return assertionList;
    }

    private XSObjectListImpl getAssertsFromComplexType(XSComplexTypeDefinition complexTypeDef, XMLAttributes attributes) {
        XSSimpleTypeDefinition simpleContentType;
        XSObjectListImpl complexTypeAsserts = new XSObjectListImpl();
        XSObjectList primaryAssertions = complexTypeDef.getAssertions();
        if (primaryAssertions.getLength() > 0) {
            for (int assertIdx = 0; assertIdx < primaryAssertions.getLength(); ++assertIdx) {
                complexTypeAsserts.addXSObject((XSAssert)primaryAssertions.get(assertIdx));
            }
        }
        if ((simpleContentType = complexTypeDef.getSimpleType()) != null) {
            int assertIdx;
            if (complexTypeDef.getDerivationMethod() == 2) {
                Vector simpleContentAsserts = XS11TypeHelper.getAssertsFromSimpleType(simpleContentType);
                for (assertIdx = 0; assertIdx < simpleContentAsserts.size(); ++assertIdx) {
                    complexTypeAsserts.addXSObject((XSAssert)simpleContentAsserts.get(assertIdx));
                }
            } else if (XS11TypeHelper.isComplexTypeDerivedFromSTList(complexTypeDef, (short)1)) {
                Vector baseItemTypeAsserts = XS11TypeHelper.getAssertsFromSimpleType(((XSSimpleTypeDefinition)complexTypeDef.getBaseType()).getItemType());
                for (assertIdx = 0; assertIdx < baseItemTypeAsserts.size(); ++assertIdx) {
                    complexTypeAsserts.addXSObject((XSAssert)baseItemTypeAsserts.get(assertIdx));
                }
            }
        }
        XSObjectListImpl attrAsserts = this.getAssertsFromAttributes(attributes);
        int attrAssertCount = attrAsserts.getLength();
        for (int attrAssertIdx = 0; attrAssertIdx < attrAssertCount; ++attrAssertIdx) {
            complexTypeAsserts.addXSObject(attrAsserts.item(attrAssertIdx));
        }
        if (attrAssertCount > 0) {
            this.fAttributesHaveAsserts = true;
        }
        return complexTypeAsserts;
    }

    private XSObjectListImpl getAssertsFromAttributes(XMLAttributes attributes) {
        XSObjectListImpl attrAssertList = new XSObjectListImpl();
        ArrayList<XSSimpleTypeDefinition> xsTypeList = new ArrayList<XSSimpleTypeDefinition>();
        for (int attrIndx = 0; attrIndx < attributes.getLength(); ++attrIndx) {
            Augmentations attrAugs = attributes.getAugmentations(attrIndx);
            AttributePSVImpl attrPSVI = (AttributePSVImpl)attrAugs.getItem("ATTRIBUTE_PSVI");
            XSSimpleTypeDefinition attrType = (XSSimpleTypeDefinition)attrPSVI.getTypeDefinition();
            if (attrType == null || XS11TypeHelper.isListContainsType(xsTypeList, attrType)) continue;
            xsTypeList.add(attrType);
            List attrAsserts = this.getAssertsFromSimpleType(attrType);
            if (attrAsserts == null) continue;
            Iterator iter = attrAsserts.iterator();
            while (iter.hasNext()) {
                attrAssertList.addXSObject((XSAssertImpl)iter.next());
            }
        }
        return attrAssertList;
    }

    public List getAssertsFromSimpleType(XSSimpleTypeDefinition simpleTypeDef) {
        XSAssertImpl assertImpl;
        Vector<XSAssertImpl> simpleTypeAsserts = null;
        XSObjectListImpl facetList = (XSObjectListImpl)simpleTypeDef.getMultiValueFacets();
        if (facetList.getLength() == 0 && simpleTypeDef.getItemType() != null) {
            facetList = (XSObjectListImpl)simpleTypeDef.getItemType().getMultiValueFacets();
        } else if (simpleTypeDef.getVariety() == 3 && (assertImpl = this.getFirstAssertFromUnionMemberTypes(simpleTypeDef.getMemberTypes())) != null) {
            simpleTypeAsserts = new Vector<XSAssertImpl>();
            simpleTypeAsserts.add(assertImpl);
        }
        for (int facetIdx = 0; facetIdx < facetList.getLength(); ++facetIdx) {
            XSMultiValueFacet facet = (XSMultiValueFacet)facetList.item(facetIdx);
            if (facet.getFacetKind() != 16384) continue;
            if (simpleTypeAsserts == null) {
                simpleTypeAsserts = new Vector();
            }
            simpleTypeAsserts.addAll(facet.getAsserts());
        }
        return simpleTypeAsserts;
    }

    private XSAssertImpl getFirstAssertFromUnionMemberTypes(XSObjectList unionMemberTypes) {
        XSAssertImpl assertImpl = null;
        for (int memberTypeIdx = 0; memberTypeIdx < unionMemberTypes.getLength(); ++memberTypeIdx) {
            Vector memberTypeAsserts;
            XSSimpleTypeDefinition unionMemberType = (XSSimpleTypeDefinition)unionMemberTypes.item(memberTypeIdx);
            if (SchemaSymbols.URI_SCHEMAFORSCHEMA.equals(unionMemberType.getNamespace()) || (memberTypeAsserts = XS11TypeHelper.getAssertsFromSimpleType(unionMemberType)).isEmpty()) continue;
            assertImpl = (XSAssertImpl)memberTypeAsserts.get(0);
            break;
        }
        return assertImpl;
    }

    private void initializeAssertProcessor(Map assertParams) {
        String assertProcessorProp;
        try {
            assertProcessorProp = SecuritySupport.getSystemProperty("org.mule.apache.xerces.assertProcessor");
        }
        catch (SecurityException se) {
            assertProcessorProp = null;
        }
        if (assertProcessorProp == null || assertProcessorProp.length() == 0) {
            this.fAssertionProcessor = new XMLAssertPsychopathXPath2Impl(assertParams);
        } else {
            try {
                ClassLoader cl = ObjectFactory.findClassLoader();
                Class assertClass = ObjectFactory.findProviderClass(assertProcessorProp, cl, true);
                this.fAssertionProcessor = (XMLAssertHandler)assertClass.newInstance();
            }
            catch (ClassNotFoundException ex) {
                throw new XNIException(ex.getMessage(), ex);
            }
            catch (InstantiationException ex) {
                throw new XNIException(ex.getMessage(), ex);
            }
            catch (IllegalAccessException ex) {
                throw new XNIException(ex.getMessage(), ex);
            }
        }
        this.fAssertionProcessor.setProperty("http://apache.org/xml/properties/assert/validator", this.fXmlSchemaValidator);
    }

    void extraCheckForSTUnionAssertsAttrs(XMLAttributes attributes) {
        XMLAttributesImpl attrsImpl = (XMLAttributesImpl)attributes;
        for (int attrIdx = 0; attrIdx < attrsImpl.getLength(); ++attrIdx) {
            Augmentations attrAugs = attrsImpl.getAugmentations(attrIdx);
            AttributePSVImpl attrPsvi = (AttributePSVImpl)attrAugs.getItem("ATTRIBUTE_PSVI");
            XSSimpleTypeDefinition attrSimpleType = (XSSimpleTypeDefinition)attrPsvi.getTypeDefinition();
            List isAssertProcessingNeededForSTUnionAttrs = this.fXmlSchemaValidator.getIsAssertProcessingNeededForSTUnionAttrs();
            if (attrSimpleType != null && attrSimpleType.getVariety() == 3 && ((XSSimpleType)attrSimpleType.getBaseType()).getVariety() != 3) {
                if (XS11TypeHelper.isAtomicStrValueValidForSTUnion(attrSimpleType.getMemberTypes(), attrsImpl.getValue(attrIdx), attrPsvi.fValue, (short)4)) {
                    isAssertProcessingNeededForSTUnionAttrs.add(false);
                    continue;
                }
                isAssertProcessingNeededForSTUnionAttrs.add(true);
                continue;
            }
            isAssertProcessingNeededForSTUnionAttrs.add(true);
        }
    }

    void extraCheckForSTUnionAssertsElem(XSSimpleType simpleTypeDv, String content, ValidatedInfo validatedInfo) {
        if (simpleTypeDv.getVariety() == 3 && ((XSSimpleType)simpleTypeDv.getBaseType()).getVariety() != 3 && XS11TypeHelper.isAtomicStrValueValidForSTUnion(simpleTypeDv.getMemberTypes(), content, validatedInfo, (short)4)) {
            this.fXmlSchemaValidator.setIsAssertProcessingNeededForSTUnionElem(false);
        }
    }
}

