/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.exporter.optel.resources;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.runtime.tracer.exporter.api.config.SpanExporterConfiguration;
import org.mule.runtime.tracer.impl.exporter.capturer.CapturingSpanExporterWrapper;
import org.mule.runtime.tracer.impl.exporter.config.type.OpenTelemetryExporterTransport;
import org.mule.runtime.tracer.impl.exporter.optel.resources.SpanExporterConfiguratorException;

public class OpenTelemetryResources {
    private static final ContextPropagators PROPAGATOR = ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance());
    public static final AttributeKey<String> SERVICE_NAME_KEY = AttributeKey.stringKey((String)"service.name");
    private static final String MULE_INSTRUMENTATION_NAME = "mule-tracer";
    private static final String INSTRUMENTATION_VERSION = "1.0.0";
    private static final CapturingSpanExporterWrapper capturingSpanExporterWrapper = new CapturingSpanExporterWrapper(new DummySpanExporter());
    private static final Cache<String, Tracer> tracerCache = Caffeine.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();

    private OpenTelemetryResources() {
    }

    public static Tracer getTracer(SpanExporterConfiguration spanExporterConfiguration, String serviceName) throws SpanExporterConfiguratorException {
        return (Tracer)tracerCache.get((Object)serviceName, name -> OpenTelemetryResources.doGetTracer(spanExporterConfiguration, name));
    }

    private static Tracer doGetTracer(SpanExporterConfiguration spanExporterConfiguration, String serviceName) throws SpanExporterConfiguratorException {
        SdkTracerProviderBuilder sdkTracerProviderBuilder = SdkTracerProvider.builder();
        Resource resource = OpenTelemetryResources.getResource(serviceName);
        sdkTracerProviderBuilder = sdkTracerProviderBuilder.addSpanProcessor(OpenTelemetryResources.resolveExporterProcessor(spanExporterConfiguration));
        SdkTracerProvider sdkTracerProvider = sdkTracerProviderBuilder.setResource(resource).build();
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setTracerProvider(sdkTracerProvider).setPropagators(OpenTelemetryResources.getPropagator()).build();
        return openTelemetry.getTracer(MULE_INSTRUMENTATION_NAME, INSTRUMENTATION_VERSION);
    }

    public static Resource getResource(String serviceName) {
        return Resource.getDefault().merge(Resource.create((Attributes)Attributes.of(SERVICE_NAME_KEY, (Object)serviceName)));
    }

    public static ExportedSpanSniffer getNewExportedSpanCapturer() {
        return capturingSpanExporterWrapper.getSpanCapturer();
    }

    private static SpanProcessor resolveDummyExporterWithSniffer() {
        return SimpleSpanProcessor.create((SpanExporter)capturingSpanExporterWrapper);
    }

    public static ContextPropagators getPropagator() {
        return PROPAGATOR;
    }

    public static SpanProcessor resolveExporterProcessor(SpanExporterConfiguration spanExporterConfiguration) throws SpanExporterConfiguratorException {
        if (!Boolean.parseBoolean(spanExporterConfiguration.getStringValue("mule.open.telemetry.exporter.enabled", Boolean.FALSE.toString()))) {
            return OpenTelemetryResources.resolveDummyExporterWithSniffer();
        }
        int batchSize = Integer.parseInt(spanExporterConfiguration.getStringValue("mule.open.telemetry.exporter.batch.max.size", "512"));
        if (batchSize < 512) {
            throw new SpanExporterConfiguratorException("The batch max size cannot be lower than 512");
        }
        int batchMaxQueueSize = Integer.parseInt(spanExporterConfiguration.getStringValue("mule.open.telemetry.exporter.batch.queue.size", "2048"));
        return BatchSpanProcessor.builder((SpanExporter)OpenTelemetryResources.createExporter(spanExporterConfiguration)).setMaxQueueSize(batchMaxQueueSize).setMaxExportBatchSize(batchSize).build();
    }

    private static SpanExporter createExporter(SpanExporterConfiguration spanExporterConfiguration) throws SpanExporterConfiguratorException {
        String type = spanExporterConfiguration.getStringValue("mule.open.telemetry.exporter.type");
        if (type == null) {
            throw new SpanExporterConfiguratorException("A type for span export was not created");
        }
        try {
            return OpenTelemetryExporterTransport.valueOf(type).getSpanExporterConfigurator().configExporter(spanExporterConfiguration);
        }
        catch (Exception e) {
            throw new SpanExporterConfiguratorException(e);
        }
    }

    private static class DummySpanExporter
    implements SpanExporter {
        private DummySpanExporter() {
        }

        public CompletableResultCode export(Collection<SpanData> collection) {
            return new CompletableResultCode().succeed();
        }

        public CompletableResultCode flush() {
            return new CompletableResultCode().succeed();
        }

        public CompletableResultCode shutdown() {
            return new CompletableResultCode().succeed();
        }
    }
}

