/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.internal.model.ExtensionModelHelper;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthParameterModelProperty;
import org.mule.runtime.extension.api.declaration.type.annotation.TypedValueTypeAnnotation;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.internal.declaration.type.MetadataTypeConstants;
import org.mule.runtime.module.extension.internal.loader.java.enricher.MetadataTypeEnricher;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.StereotypeModelFactory;
import org.mule.runtime.module.extension.mule.internal.loader.parser.BaseMuleSdkExtensionModelParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.ParameterLayoutParser;

public class MuleSdkParameterModelParser
extends BaseMuleSdkExtensionModelParser
implements ParameterModelParser {
    private static final MetadataTypeEnricher METADATA_TYPE_ENRICHER = new MetadataTypeEnricher();
    private static final Set<TypeAnnotation> METADATA_TYPE_ANNOTATIONS = Collections.singleton(new TypedValueTypeAnnotation());
    protected final ComponentAst parameterAst;
    private final TypeLoader typeLoader;
    private final ExtensionModelHelper extensionModelHelper;
    private String name;
    private MetadataType type;
    private List<StereotypeModel> allowedStereotypes = Collections.emptyList();
    private Optional<ParameterDslConfiguration> dslConfiguration = Optional.empty();
    private ParameterLayoutParser parameterLayoutParser;

    public MuleSdkParameterModelParser(ComponentAst parameterAst, TypeLoader typeLoader, ExtensionModelHelper extensionModelHelper) {
        this.parameterAst = parameterAst;
        this.typeLoader = typeLoader;
        this.extensionModelHelper = extensionModelHelper;
        this.parseStructure();
    }

    private void parseStructure() {
        this.parseName();
        this.parseType();
        this.parseLayout();
    }

    private void parseLayout() {
        this.parameterLayoutParser = new ParameterLayoutParser(this.parameterAst);
    }

    private void parseName() {
        this.name = (String)this.getParameter(this.parameterAst, "name");
    }

    private void parseType() {
        String type = (String)this.getParameter(this.parameterAst, "type");
        if ("void".equals(type)) {
            throw new IllegalModelDefinitionException(this.voidParameterIsForbidden());
        }
        if (!this.parseTypeFromTypeLoader(type) && !this.parseTypeAsConfigurationName(type)) {
            throw new IllegalModelDefinitionException(this.unknownType(type));
        }
    }

    private boolean parseTypeFromTypeLoader(String type) {
        Optional metadataType = this.typeLoader.load(type);
        if (!metadataType.isPresent()) {
            return false;
        }
        this.type = METADATA_TYPE_ENRICHER.enrich((MetadataType)metadataType.get(), METADATA_TYPE_ANNOTATIONS);
        return true;
    }

    private boolean parseTypeAsConfigurationName(String type) {
        ComponentIdentifier componentIdentifier = ComponentIdentifier.buildFromStringRepresentation((String)type);
        Optional configurationModel = this.extensionModelHelper.findConfigurationModel(componentIdentifier);
        if (!configurationModel.isPresent()) {
            return false;
        }
        this.type = MetadataTypeConstants.CONFIG_TYPE;
        this.dslConfiguration = Optional.of(ParameterDslConfiguration.builder().allowsReferences(true).build());
        this.allowedStereotypes = Collections.singletonList(((ConfigurationModel)configurationModel.get()).getStereotype());
        return true;
    }

    public List<StereotypeModel> getAllowedStereotypes(StereotypeModelFactory factory) {
        return this.allowedStereotypes;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.getOptionalParameter(this.parameterAst, "description").orElse("");
    }

    public MetadataType getType() {
        return this.type;
    }

    private String unknownType(String type) {
        return String.format("Parameter '%s' references unknown type '%s'", this.getName(), type);
    }

    private String voidParameterIsForbidden() {
        return String.format("Parameter '%s' references type '%s', which is forbidden for parameters", this.getName(), "void");
    }

    public boolean isRequired() {
        return true;
    }

    public Object getDefaultValue() {
        return null;
    }

    public ParameterRole getRole() {
        if (((Boolean)this.getParameter(this.parameterAst, "allowInlineScript")).booleanValue()) {
            return ParameterRole.CONTENT;
        }
        return ParameterRole.BEHAVIOUR;
    }

    public ExpressionSupport getExpressionSupport() {
        return ExpressionSupport.valueOf((String)((String)this.getParameter(this.parameterAst, "expressionSupport")));
    }

    public Optional<LayoutModel> getLayoutModel() {
        return this.parameterLayoutParser.getLayoutModel();
    }

    public Optional<ParameterDslConfiguration> getDslConfiguration() {
        return this.dslConfiguration;
    }

    public boolean isExcludedFromConnectivitySchema() {
        return false;
    }

    public boolean isConfigOverride() {
        return (Boolean)this.getParameter(this.parameterAst, "configOverride");
    }

    public boolean isComponentId() {
        return false;
    }

    public List<ModelProperty> getAdditionalModelProperties() {
        return Collections.emptyList();
    }

    public Optional<DeprecationModel> getDeprecationModel() {
        return this.getSingleChild(this.parameterAst, "deprecated").map(this::buildDeprecationModel);
    }

    public Optional<DisplayModel> getDisplayModel() {
        return this.parameterLayoutParser.getDisplayModel();
    }

    public Optional<OAuthParameterModelProperty> getOAuthParameterModelProperty() {
        return Optional.empty();
    }

    public Set<String> getSemanticTerms() {
        return Collections.unmodifiableSet(this.parameterLayoutParser.getSemanticTerms());
    }
}

