/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.config;

import com.hazelcast.config.Config;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.spi.discovery.DiscoveryStrategyFactory;
import com.hazelcast.spi.properties.GroupProperty;
import com.mulesoft.mule.runtime.module.cluster.internal.config.HazelcastConfig;
import com.mulesoft.mule.runtime.module.cluster.internal.config.HazelcastUtils;
import com.mulesoft.mule.runtime.module.cluster.internal.config.MuleDistributedObjectConfigurator;
import com.mulesoft.mule.runtime.module.cluster.internal.config.persistence.JdbcMapStoreConfigConfigurator;
import com.mulesoft.mule.runtime.module.cluster.internal.config.quorum.HazelcastQuorumConfigurator;
import com.mulesoft.mule.runtime.module.cluster.internal.discoveryspi.MuleRuntimeDiscoveryStrategyFactory;
import com.mulesoft.mule.runtime.module.cluster.internal.listener.LoggingClusterMembershipListener;
import com.mulesoft.mule.runtime.module.cluster.internal.persistence.JdbcMapStoreSerializationProtocol;
import java.util.Properties;
import java.util.Random;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;

public class HazelcastPropertiesConfig
implements HazelcastConfig {
    private static final String HAZELCAST_JMX_KEY = "hazelcast.jmx";
    private static final String FALSE_PROP = "false";
    private MuleDistributedObjectConfigurator muleDistributedObjectConfigurator = new MuleDistributedObjectConfigurator();
    public static final String HAZELCAST_SHUTDOWNHOOK_PROPERTY = "hazelcast.shutdownhook.enabled";
    public static final String CLUSTER_MANAGEMENTCENTER_URL = "mule.cluster.managementcenterurl";
    public static final String HAZELCAST_GW_MAPS_PREFIX = "gateway-policies-map-*";
    public static final String INVALID_QUORUM_SIZE_MESSAGE_PREFIX = "Invalid value for cluster quorum size: ";
    public static final String THROTTLING_ALGORITHM_EXECUTION_SERVICE_ID_TEMPLATE = "throttling-algorithm-execution-%s";
    public static final String HAZELCAST_HEALTHCHECK_PROPERTY = "hazelcast.http.healthcheck.enabled";
    private Properties clusterProperties;

    public HazelcastPropertiesConfig(Properties properties) {
        this.clusterProperties = properties;
    }

    @Override
    public Config createConfig(Config config) {
        boolean readBackData = Boolean.valueOf(this.clusterProperties.getProperty("mule.cluster.readbackdata", FALSE_PROP));
        Integer backups = Integer.valueOf(this.clusterProperties.getProperty("mule.cluster.backupnodes", "1"));
        this.configureClusterDiscoverySPI(config);
        this.configureClusterGroup(config);
        this.configNetworkInterfacesRestriction(config);
        this.configureNodeDiscoveryMode(config);
        this.configureInboundAndOutboundPorts(config);
        this.muleDistributedObjectConfigurator.configure(config, readBackData, backups);
        this.configureManagementCenter(config);
        this.configureClusterQuorum(config);
        this.configureJdbcMapStore(config);
        this.configureListeners(config);
        this.configureJMX(config);
        this.disableHazelcastShutdownHook(config);
        return config;
    }

    private void addIfPresent(String propertyKey, DiscoveryStrategyConfig discoveryStrategyConfig) {
        String propertyValue = this.clusterProperties.getProperty(propertyKey);
        if (propertyValue != null) {
            discoveryStrategyConfig.addProperty(propertyKey, (Comparable)((Object)propertyValue));
        }
    }

    private void configureClusterDiscoverySPI(Config config) {
        if (HazelcastUtils.validDiscoveryStrategy(this.clusterProperties.getProperty("mule.cluster.discoverymechanism"))) {
            config.setProperty(HAZELCAST_HEALTHCHECK_PROPERTY, "true");
            config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
            config.setProperty(GroupProperty.DISCOVERY_SPI_ENABLED.getName(), "true");
            DiscoveryStrategyConfig discoveryStrategyConfig = new DiscoveryStrategyConfig((DiscoveryStrategyFactory)new MuleRuntimeDiscoveryStrategyFactory());
            this.addIfPresent("mule.clusterId", discoveryStrategyConfig);
            this.addIfPresent("mule.cluster.discoverymechanism.url", discoveryStrategyConfig);
            this.addIfPresent("mule.cluster.discoverymechanism", discoveryStrategyConfig);
            config.getNetworkConfig().getJoin().getDiscoveryConfig().addDiscoveryStrategyConfig(discoveryStrategyConfig);
        }
    }

    private void configureGatewayPoliciesMaps(Config config) {
        MapConfig gatewayPoliciesMapConfig = new MapConfig();
        gatewayPoliciesMapConfig.setName(HAZELCAST_GW_MAPS_PREFIX);
        config.addMapConfig(gatewayPoliciesMapConfig);
    }

    private void configureInboundAndOutboundPorts(Config config) {
        String outboundPort;
        String inboundPort = this.clusterProperties.getProperty("mule.cluster.tcpinboundport");
        if (inboundPort != null) {
            config.getNetworkConfig().setPortAutoIncrement(false);
            config.getNetworkConfig().setPort(Integer.valueOf(inboundPort).intValue());
        }
        if ((outboundPort = this.clusterProperties.getProperty("mule.cluster.tcpoutboundport")) != null) {
            config.getNetworkConfig().addOutboundPort(Integer.valueOf(outboundPort).intValue());
        }
    }

    private void configureManagementCenter(Config config) {
        boolean managementCenterEnabled = Boolean.valueOf(this.clusterProperties.getProperty("mule.cluster.managementcenterenabled", FALSE_PROP));
        String managementCenterUrl = this.clusterProperties.getProperty(CLUSTER_MANAGEMENTCENTER_URL, null);
        config.getManagementCenterConfig().setEnabled(managementCenterEnabled);
        config.getManagementCenterConfig().setUrl(managementCenterUrl);
    }

    private void disableHazelcastShutdownHook(Config config) {
        config.setProperty(HAZELCAST_SHUTDOWNHOOK_PROPERTY, FALSE_PROP);
    }

    private MapConfig configureDistributedMaps(Config config, boolean readBackData, Integer backups) {
        MapConfig defaultMapConfig = new MapConfig();
        defaultMapConfig.setName("*");
        defaultMapConfig.setReadBackupData(readBackData);
        defaultMapConfig.setBackupCount(backups.intValue());
        return defaultMapConfig;
    }

    private void configureDistributedQueues(Config config, Integer backups) {
        QueueConfig defaultQueueConfig = new QueueConfig();
        defaultQueueConfig.setName("*");
        defaultQueueConfig.setBackupCount(backups.intValue());
        config.addQueueConfig(defaultQueueConfig);
    }

    private void configureDistributedThrottlingExecutorService(Config config) {
        config.getExecutorConfig(THROTTLING_ALGORITHM_EXECUTION_SERVICE_ID_TEMPLATE.replace("%s", "*")).setPoolSize(100);
    }

    private void configureClusterGroup(Config config) {
        String nodeId = this.clusterProperties.getProperty("mule.clusterNodeId", String.valueOf(new Random().nextInt()));
        String clusterId = this.clusterProperties.getProperty("mule.clusterId", config.getGroupConfig().getName());
        String password = this.clusterProperties.getProperty("mule.password", config.getGroupConfig().getPassword());
        config.getGroupConfig().setName(clusterId);
        config.getGroupConfig().setPassword(password);
        config.setInstanceName(nodeId);
    }

    private void configureClusterQuorum(Config config) {
        if (this.clusterProperties.containsKey("mule.cluster.quorumsize")) {
            String quorumSizeString = this.clusterProperties.getProperty("mule.cluster.quorumsize");
            try {
                int quorumSize = Integer.valueOf(quorumSizeString);
                HazelcastQuorumConfigurator.configureClusterQuorum(config, quorumSize);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)(INVALID_QUORUM_SIZE_MESSAGE_PREFIX + quorumSizeString)));
            }
        }
    }

    private void configureJdbcMapStore(Config config) {
        String jdbcStoreUrl = this.clusterProperties.getProperty("mule.cluster.jdbcstoreurl");
        String jdbcStoreUsername = this.clusterProperties.getProperty("mule.cluster.jdbcstoreusername");
        String jdbcStorePassword = this.clusterProperties.getProperty("mule.cluster.jdbcstorepassword");
        String jdbcStoreDriver = this.clusterProperties.getProperty("mule.cluster.jdbcstoredriver");
        String jdbcStoreQueryStrategy = this.clusterProperties.getProperty("mule.cluster.jdbcstorequerystrategy");
        String jdbcStoreTableNameTransformerStrategy = this.clusterProperties.getProperty("mule.cluster.jdbcstoretableNametransformerstrategy");
        if (jdbcStoreUrl != null && jdbcStoreDriver != null && jdbcStoreQueryStrategy != null) {
            ClassLoaderRepository repository = (ClassLoaderRepository)config.getProperties().get(ClassLoaderRepository.class.getName());
            JdbcMapStoreSerializationProtocol serializationProtocol = new JdbcMapStoreSerializationProtocol(repository);
            JdbcMapStoreConfigConfigurator.configure(config, jdbcStoreUrl, jdbcStoreDriver, jdbcStoreUsername, jdbcStorePassword, jdbcStoreQueryStrategy, serializationProtocol, jdbcStoreTableNameTransformerStrategy, this.clusterProperties);
        }
    }

    private void configureJMX(Config config) {
        if (this.clusterProperties.containsKey("mule.cluster.jmxenabled")) {
            String jMXEnabled = this.clusterProperties.getProperty("mule.cluster.jmxenabled", FALSE_PROP);
            config.setProperty(HAZELCAST_JMX_KEY, jMXEnabled);
        }
    }

    private void configureListeners(Config config) {
        boolean listenersEnabled;
        if (this.clusterProperties.containsKey("mule.cluster.listenersenabled") && (listenersEnabled = Boolean.valueOf(this.clusterProperties.getProperty("mule.cluster.listenersenabled", FALSE_PROP)).booleanValue())) {
            config.addListenerConfig(new ListenerConfig(LoggingClusterMembershipListener.class.getName()));
        }
    }

    private void configureNodeDiscoveryMode(Config config) {
        if (HazelcastUtils.validDiscoveryStrategy(this.clusterProperties.getProperty("mule.cluster.discoverymechanism"))) {
            return;
        }
        String multicastGroup = this.clusterProperties.getProperty("mule.cluster.multicastgroup", "224.2.2.3");
        Integer multicastPort = Integer.valueOf(this.clusterProperties.getProperty("mule.cluster.multicastport", "54327"));
        String clusterNodes = this.clusterProperties.getProperty("mule.cluster.nodes");
        Integer tcpIpConnectionTimeoutSecs = Integer.valueOf(this.clusterProperties.getProperty("mule.cluster.tcpiptimeout", "20"));
        if (clusterNodes != null) {
            this.configDirectNodeDiscoveryMode(config, clusterNodes, tcpIpConnectionTimeoutSecs);
        } else {
            this.configMulticast(config, multicastGroup, multicastPort);
        }
        String splitMergeDelay = this.clusterProperties.getProperty("mule.cluster.splitmergedelay", "5");
        this.configSplitBrainMergeDelay(config, splitMergeDelay);
    }

    private void configSplitBrainMergeDelay(Config config, String delay) {
        config.setProperty(GroupProperty.MERGE_FIRST_RUN_DELAY_SECONDS.getName(), delay);
        config.setProperty(GroupProperty.MERGE_NEXT_RUN_DELAY_SECONDS.getName(), delay);
    }

    private void configMulticast(Config config, String multicastGroup, Integer multicastPort) {
        config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(false);
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(true);
        config.getNetworkConfig().getJoin().getMulticastConfig().setMulticastGroup(multicastGroup);
        config.getNetworkConfig().getJoin().getMulticastConfig().setMulticastPort(multicastPort.intValue());
    }

    private void configDirectNodeDiscoveryMode(Config config, String clusterNodes, Integer tcpIpConnectionTimeoutSecs) {
        String[] clusterNodesList = clusterNodes.split(",");
        config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(true);
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        config.getNetworkConfig().getJoin().getTcpIpConfig().setConnectionTimeoutSeconds(tcpIpConnectionTimeoutSecs.intValue());
        String[] stringArray = clusterNodesList;
        int n = clusterNodesList.length;
        int n2 = 0;
        while (n2 < n) {
            String clusterNode = stringArray[n2];
            config.getNetworkConfig().getJoin().getTcpIpConfig().addMember(clusterNode.trim());
            ++n2;
        }
    }

    private void configNetworkInterfacesRestriction(Config config) {
        String interfacesProp = this.clusterProperties.getProperty("mule.cluster.networkinterfaces", null);
        if (interfacesProp != null) {
            String[] interfaces = interfacesProp.split(",");
            InterfacesConfig hazelcastInterfacesConfig = config.getNetworkConfig().getInterfaces();
            String[] stringArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                String anInterface = stringArray[n2];
                hazelcastInterfacesConfig.addInterface(anInterface.trim());
                ++n2;
            }
            hazelcastInterfacesConfig.setEnabled(true);
        }
    }
}

