/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MigrationEvent;
import com.hazelcast.core.MigrationListener;
import com.hazelcast.core.Partition;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClusterManager;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastPartitionLogger
implements MigrationListener {
    private static final Logger logger = LoggerFactory.getLogger(HazelcastClusterManager.class);
    private HazelcastInstance hazelcastInstance;
    private Set<Integer> lastPartitionStatus;

    public HazelcastPartitionLogger(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    private void logPartitionState() {
        try {
            if (this.hazelcastInstance.getLifecycleService().isRunning()) {
                Set<Integer> ourPartitions = this.getPartitionStatus();
                if (this.lastPartitionStatus == null || !this.lastPartitionStatus.equals(ourPartitions)) {
                    this.logPartitionStatus(ourPartitions);
                } else {
                    this.logNoPartitionChange();
                }
                this.lastPartitionStatus = ourPartitions;
            }
        }
        catch (Exception ex) {
            logger.debug("Exception analyzing partitions", (Throwable)ex);
        }
    }

    private void logNoPartitionChange() {
        logger.debug("No partition change for this node");
    }

    private Set<Integer> getPartitionStatus() {
        Set partitions = this.hazelcastInstance.getPartitionService().getPartitions();
        TreeSet<Integer> ourPartitions = new TreeSet<Integer>();
        for (Partition p : partitions) {
            if (p.getOwner() == null || !p.getOwner().localMember()) continue;
            ourPartitions.add(p.getPartitionId());
        }
        return ourPartitions;
    }

    private void logPartitionStatus(Set<Integer> ourPartitions) {
        StringBuilder partitionsString = new StringBuilder();
        int start = -1;
        int current = -1;
        for (int i : ourPartitions) {
            if (start < 0) {
                current = start = i;
                continue;
            }
            if (i == current + 1) {
                current = i;
                continue;
            }
            this.appendSegment(partitionsString, start, current);
            current = start = i;
        }
        if (start >= 0) {
            this.appendSegment(partitionsString, start, current);
        }
        String partitionsStr = partitionsString.toString();
        logger.debug("Current cluster partitions are: " + partitionsStr + " Total: " + ourPartitions.size());
    }

    private void appendSegment(StringBuilder partitionsString, int start, int current) {
        if (partitionsString.length() > 0) {
            partitionsString.append(",");
        }
        partitionsString.append(start);
        if (current > start) {
            partitionsString.append("-");
            partitionsString.append(current);
        }
    }

    public void migrationCompleted(MigrationEvent migrationEvent) {
        if (logger.isDebugEnabled()) {
            logger.debug("Partition migration complete");
            this.logPartitionState();
        }
    }

    public void migrationFailed(MigrationEvent migrationEvent) {
        if (logger.isDebugEnabled()) {
            logger.debug("Partition migration failed");
        }
    }

    public void migrationStarted(MigrationEvent migrationEvent) {
        if (logger.isDebugEnabled()) {
            logger.debug("Partition migration started");
        }
    }
}

