/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.session.validation;

import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.module.tooling.internal.artifact.metadata.MetadataKeyDeclarationResolver;
import org.mule.runtime.module.tooling.internal.artifact.metadata.MetadataKeyResult;
import org.mule.tooling.client.internal.session.validation.ComponentValidationContext;
import org.mule.tooling.client.internal.session.validation.SessionCallValidationException;
import org.mule.tooling.client.internal.session.validation.Validators;

public class ComponentMetadataKeyValidator
implements Validators.ComponentValidator {
    private ComponentElementDeclaration componentElementDeclaration;

    public ComponentMetadataKeyValidator(ComponentElementDeclaration componentElementDeclaration) {
        this.componentElementDeclaration = componentElementDeclaration;
    }

    @Override
    public void validate(ComponentValidationContext<?> context) throws SessionCallValidationException {
        Optional<ComponentModel> componentModelOptional = context.getComponentModel();
        if (componentModelOptional.isPresent()) {
            try {
                MetadataKeyResult metadataKeyResult = new MetadataKeyDeclarationResolver(componentModelOptional.get(), this.componentElementDeclaration).resolveKeyResult();
                if (!metadataKeyResult.isComplete()) {
                    throw new SessionCallValidationException(metadataKeyResult.getPartialReason(), metadataKeyResult.getPartialReason(), FailureCode.INVALID_METADATA_KEY.getName());
                }
            }
            catch (Exception e) {
                throw new SessionCallValidationException(e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e), FailureCode.INVALID_METADATA_KEY.getName());
            }
        }
    }
}

