/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.external.handlers.deployment;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.inject.Inject;
import com.mulesoft.agent.domain.deployment.Application;
import com.mulesoft.agent.domain.deployment.ArtifactState;
import com.mulesoft.agent.exception.AgentApplicationConfigurationException;
import com.mulesoft.agent.exception.AgentDeploymentException;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.exception.ApplicationValidationException;
import com.mulesoft.agent.exception.ConcurrentDeploymentException;
import com.mulesoft.agent.exception.InvalidConfigurationException;
import com.mulesoft.agent.exception.NoSuchApplicationException;
import com.mulesoft.agent.exception.NoSuchComponentException;
import com.mulesoft.agent.exception.RuntimeAgentDeploymentException;
import com.mulesoft.agent.external.handlers.ConfigurableExternalHandler;
import com.mulesoft.agent.external.handlers.deployment.DeploymentRequest;
import com.mulesoft.agent.external.handlers.deployment.ErrorResponseBuilder;
import com.mulesoft.agent.services.ApplicationService;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Named(value="applications.request.handler")
@Path(value="applications")
@Singleton
public class ApplicationsRequestHandler
extends ConfigurableExternalHandler {
    private static final Logger LOGGER = LogManager.getLogger(ApplicationsRequestHandler.class);
    private static final String ERROR_DEPLOYING = "Error performing the deployment of {}. Cause: {}";
    private static final String ERROR_REDEPLOYING = "Error performing the redeployment of {}. Cause: {}";
    private static final String ERROR_UNDEPLOYING = "Error performing the undeployment of {}. Cause: {}";
    private static final String ERROR_STOP_APPLICATION = "Error performing the stop of {}. Cause: {}";
    private static final String ERROR_START_APPLICATION = "Error performing the stop of {}. Cause: {}";
    private static final String ERROR_STOP_FLOW = "Error performing the stop of the flow {} on the application {}. Cause: {}";
    private static final String ERROR_START_FLOW = "Error performing the start of the flow {} on the application {}. Cause: {}";
    private static final String ERROR_TRIGGER_FLOW = "Error performing the trigger of the flow {} on the application {}. Cause: {}";
    private static final String ERROR_GET_FLOW_STACKS = "Error retrieving flow stack of the application {}. Cause: {}";
    static final int HTTP_STATUS_LOCKED = 423;
    private static final String ERROR_MESSAGE_HANLDER_DISABLED = "Message handler is disabled";
    private Gson gson = new Gson();
    @Inject
    protected ApplicationService applicationService;

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabledSwitch.switchTo(state);
    }

    public boolean isEnabled() {
        return this.enabledSwitch.isEnabled();
    }

    @GET
    @Produces(value={"application/json"})
    public Response listApplications() throws WebApplicationException {
        if (this.isEnabled()) {
            return Response.ok((Object)this.applicationService.listApplications()).build();
        }
        String response = this.buildErrorResponse(IllegalAccessException.class.toString(), ERROR_MESSAGE_HANLDER_DISABLED);
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)response).build();
    }

    @GET
    @Path(value="{application}")
    @Produces(value={"application/json"})
    public Response getApplication(@PathParam(value="application") String appName) {
        if (this.isEnabled()) {
            Application application;
            try {
                application = this.applicationService.getApplicationSynchronized(appName);
            }
            catch (ConcurrentDeploymentException e) {
                String response = this.buildErrorResponse(ConcurrentDeploymentException.class.toString(), "There is another deployment operation in progress. Retry later");
                return Response.status((int)423).entity((Object)response).build();
            }
            if (application == null) {
                String response = this.buildErrorResponse(NoSuchElementException.class.toString(), "No such application");
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)response).build();
            }
            return Response.ok((Object)application).build();
        }
        String response = this.buildErrorResponse(IllegalAccessException.class.toString(), ERROR_MESSAGE_HANLDER_DISABLED);
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)response).build();
    }

    @PUT
    @Path(value="{application}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deploy(@PathParam(value="application") String appName, DeploymentRequest deploymentRequest) {
        return this.handleZipDeployment(appName, null, deploymentRequest.getUrl(), deploymentRequest.getConfiguration());
    }

    @PUT
    @Path(value="{application}")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    public Response deployZip(@PathParam(value="application") String appName, InputStream uploadedInputStream) throws IOException {
        return this.handleZipDeployment(appName, uploadedInputStream, null, null);
    }

    @PUT
    @Path(value="{application}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response deployZip(@PathParam(value="application") String appName, @FormDataParam(value="configuration") String configuration, @FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail) throws IOException {
        return this.handleZipDeployment(appName, uploadedInputStream, null, this.parseApplicationConfiguration(configuration));
    }

    @DELETE
    @Path(value="{application}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response undeploy(@PathParam(value="application") String appName) {
        if (this.isEnabled()) {
            try {
                Application application = this.applicationService.getApplication(appName);
                this.applicationService.undeploy(appName);
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)("{ \"application\":{\"name\":\"" + appName + "\", \"domain\":\"" + application.getDomain() + "\", \"state\":\"" + application.getState() + "\"}, \"status\":\"Undeployment attempt started\" }")).build();
            }
            catch (AgentDeploymentException e) {
                LOGGER.error(ERROR_UNDEPLOYING, (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
                String response = this.buildErrorResponse(((Object)((Object)e)).getClass().toString(), e.getMessage());
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
            }
            catch (IllegalArgumentException e) {
                LOGGER.info(ERROR_UNDEPLOYING, (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
                String response = this.buildErrorResponse(e.getClass().toString(), e.getMessage());
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)response).build();
            }
            catch (IllegalAccessException e) {
                LOGGER.error(ERROR_UNDEPLOYING, (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
                String response = this.buildErrorResponse(IllegalAccessException.class.toString(), e.getMessage());
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)response).build();
            }
        }
        String response = this.buildErrorResponse(IllegalAccessException.class.toString(), ERROR_MESSAGE_HANLDER_DISABLED);
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)response).build();
    }

    @PUT
    @Path(value="{application}/stop")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response stop(@PathParam(value="application") String appName) {
        if (this.isEnabled()) {
            try {
                Application application = this.applicationService.getApplication(appName);
                if (application != null && application.getState() == ArtifactState.STOPPED) {
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)application).build();
                }
                this.applicationService.stop(appName);
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)("{ \"application\":{\"name\":\"" + appName + "\", \"domain\":\"" + application.getDomain() + "\", \"state\":\"" + application.getState() + "\"}, \"status\":\"Stop attempt started\" }")).build();
            }
            catch (ConcurrentDeploymentException e) {
                LOGGER.error("Error performing the stop of {}. Cause: {}", (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
                String response = this.buildErrorResponse(((Object)((Object)e)).getClass().toString(), e.getMessage());
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
            }
            catch (IllegalArgumentException e) {
                LOGGER.info("Error performing the stop of {}. Cause: {}", (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
                String response = this.buildErrorResponse(e.getClass().toString(), e.getMessage());
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)response).build();
            }
            catch (IllegalStateException e) {
                LOGGER.debug((Object)e);
                Application application = this.applicationService.getApplication(appName);
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)("{ \"application\":{\"name\":\"" + appName + "\", \"domain\":\"" + application.getDomain() + "\"}, \"status\":\"Application is already stopped\" }")).build();
            }
        }
        String response = this.buildErrorResponse(IllegalAccessException.class.toString(), ERROR_MESSAGE_HANLDER_DISABLED);
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)response).build();
    }

    @PUT
    @Path(value="{application}/start")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response start(@PathParam(value="application") String appName) {
        if (this.isEnabled()) {
            try {
                Application application = this.applicationService.getApplication(appName);
                if (application != null && application.getState() == ArtifactState.STARTED) {
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)application).build();
                }
                this.applicationService.start(appName);
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)("{ \"application\":{\"name\":\"" + appName + "\", \"domain\":\"" + application.getDomain() + "\", \"state\":\"" + application.getState() + "\"}, \"status\":\"Start attempt started\" }")).build();
            }
            catch (ConcurrentDeploymentException e) {
                LOGGER.error("Error performing the stop of {}. Cause: {}", (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
                String response = this.buildErrorResponse(((Object)((Object)e)).getClass().toString(), e.getMessage());
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
            }
            catch (IllegalArgumentException e) {
                LOGGER.info("Error performing the stop of {}. Cause: {}", (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
                String response = this.buildErrorResponse(e.getClass().toString(), e.getMessage());
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)response).build();
            }
            catch (IllegalStateException e) {
                LOGGER.debug((Object)e);
                Application application = this.applicationService.getApplication(appName);
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)("{ \"application\":{\"name\":\"" + appName + "\", \"domain\":\"" + application.getDomain() + "\"}, \"status\":\"Application is already started\" }")).build();
            }
        }
        String response = this.buildErrorResponse(IllegalAccessException.class.toString(), ERROR_MESSAGE_HANLDER_DISABLED);
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)response).build();
    }

    @PUT
    @Path(value="{application}/restart")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response redeploy(@PathParam(value="application") String appName, Map<String, Map> configuration) {
        if (this.isEnabled()) {
            try {
                Application application = this.applicationService.getApplication(appName);
                this.applicationService.redeploy(appName, configuration);
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)("{ \"application\":{\"name\":\"" + appName + "\", \"domain\":\"" + application.getDomain() + "\", \"state\":\"" + application.getState() + "\"}, \"status\":\"Redeployment attempt started\" }")).build();
            }
            catch (AgentDeploymentException e) {
                LOGGER.error(ERROR_DEPLOYING, (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
                String response = this.buildErrorResponse(((Object)((Object)e)).getClass().toString(), e.getMessage());
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
            }
            catch (IllegalArgumentException e) {
                LOGGER.info(ERROR_REDEPLOYING, (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
                String response = this.buildErrorResponse(e.getClass().toString(), e.getMessage());
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)response).build();
            }
            catch (RuntimeAgentDeploymentException e) {
                LOGGER.error(ERROR_REDEPLOYING, (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
                String response = this.buildErrorResponse(((Object)((Object)e)).getClass().toString(), e.getMessage());
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
            }
        }
        String response = this.buildErrorResponse(IllegalAccessException.class.toString(), ERROR_MESSAGE_HANLDER_DISABLED);
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)response).build();
    }

    @GET
    @Path(value="{application}/flows")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getFlows(@PathParam(value="application") String appName) {
        if (this.isEnabled()) {
            try {
                List flows = this.applicationService.getFlows(appName);
                return Response.status((Response.Status)Response.Status.OK).entity((Object)flows).build();
            }
            catch (IllegalArgumentException e) {
                LOGGER.info("Couldn't retrieve the flows of the app {}. Cause: {}", (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
                String response = this.buildErrorResponse(e.getClass().toString(), e.getMessage());
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)response).build();
            }
        }
        String response = this.buildErrorResponse(IllegalAccessException.class.toString(), ERROR_MESSAGE_HANLDER_DISABLED);
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)response).build();
    }

    @PUT
    @Path(value="{application}/flows/{flow}/stop")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response stopFlow(@PathParam(value="application") String appName, @PathParam(value="flow") String flowName) {
        if (this.isEnabled()) {
            try {
                this.applicationService.stopFlow(appName, flowName);
                return Response.status((Response.Status)Response.Status.ACCEPTED).build();
            }
            catch (IllegalArgumentException e) {
                LOGGER.info(ERROR_STOP_FLOW, (Object)flowName, (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
                String response = this.buildErrorResponse(e.getClass().toString(), e.getMessage());
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)response).build();
            }
            catch (AgentApplicationConfigurationException e) {
                LOGGER.error(ERROR_STOP_FLOW, (Object)flowName, (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
                String response = this.buildErrorResponse(((Object)((Object)e)).getClass().toString(), e.getMessage());
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
            }
        }
        String response = this.buildErrorResponse(IllegalAccessException.class.toString(), ERROR_MESSAGE_HANLDER_DISABLED);
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)response).build();
    }

    @PUT
    @Path(value="{application}/flows/{flow}/start")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response startFlow(@PathParam(value="application") String appName, @PathParam(value="flow") String flowName) {
        if (this.isEnabled()) {
            try {
                this.applicationService.startFlow(appName, flowName);
                return Response.status((Response.Status)Response.Status.ACCEPTED).build();
            }
            catch (IllegalArgumentException e) {
                LOGGER.info(ERROR_START_FLOW, (Object)flowName, (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
                String response = this.buildErrorResponse(e.getClass().toString(), e.getMessage());
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)response).build();
            }
            catch (AgentApplicationConfigurationException e) {
                LOGGER.warn(ERROR_START_FLOW, (Object)flowName, (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
                String response = this.buildErrorResponse(((Object)((Object)e)).getClass().toString(), e.getMessage());
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
            }
        }
        String response = this.buildErrorResponse(IllegalAccessException.class.toString(), ERROR_MESSAGE_HANLDER_DISABLED);
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)response).build();
    }

    @GET
    @Path(value="{application}/flowsStack")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getCurrentlyActiveFlowStacks(@PathParam(value="application") String applicationName) {
        if (this.isEnabled()) {
            try {
                return Response.status((Response.Status)Response.Status.OK).entity((Object)this.applicationService.getCurrentlyActiveFlowStacks(applicationName)).build();
            }
            catch (NoSuchApplicationException e) {
                LOGGER.info(ERROR_GET_FLOW_STACKS, (Object)applicationName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
                String response = this.buildErrorResponse(((Object)((Object)e)).getClass().toString(), e.getMessage());
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)response).build();
            }
        }
        String response = this.buildErrorResponse(IllegalAccessException.class.toString(), ERROR_MESSAGE_HANLDER_DISABLED);
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)response).build();
    }

    private Response handleZipDeployment(String appName, InputStream uploadedInputStream, String url, Map<String, Map> configuration) {
        if (!this.isEnabled()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
        }
        try {
            Application application = this.applicationService.getApplication(appName);
            if (application == null || application.getState() == ArtifactState.DESTROYED || application.getState() == ArtifactState.DEPLOYMENT_FAILED) {
                if (uploadedInputStream != null) {
                    this.applicationService.deploy(appName, uploadedInputStream, configuration);
                } else {
                    this.applicationService.deploy(appName, url, configuration);
                }
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)("{ \"application\":{\"name\":\"" + appName + "\"}, \"status\":\"Deployment attempt started\" }")).build();
            }
            if (uploadedInputStream != null) {
                this.applicationService.redeploy(appName, uploadedInputStream, configuration);
            } else {
                this.applicationService.redeploy(appName, url, configuration);
            }
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)("{ \"application\":{\"name\":\"" + appName + "\", \"domain\":\"" + application.getDomain() + "\", \"state\":\"" + application.getState() + "\"}, \"status\":\"Deployment attempt started\" }")).build();
        }
        catch (AgentDeploymentException e) {
            LOGGER.error(ERROR_DEPLOYING, (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug((Object)e);
            String response = this.buildErrorResponse(((Object)((Object)e)).getClass().toString(), e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
        catch (ApplicationValidationException | IllegalArgumentException e) {
            LOGGER.info(ERROR_DEPLOYING, (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug((Object)e);
            String response = this.buildErrorResponse(e.getClass().toString(), e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)response).build();
        }
        catch (InvalidConfigurationException | NoSuchComponentException e) {
            LOGGER.error(ERROR_REDEPLOYING, (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug((Object)e);
            String response = this.buildErrorResponse(e.getClass().toString(), e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)response).build();
        }
    }

    private Map<String, Map> parseApplicationConfiguration(String configuration) {
        Map configurationMap = new HashMap<String, Map>();
        if (configuration != null) {
            try {
                configurationMap = (Map)this.gson.fromJson(configuration, Map.class);
            }
            catch (JsonSyntaxException e) {
                LOGGER.error("Configuration doesn't have a valid JSON format: {}", (Object)configuration);
                throw new IllegalArgumentException("Deployment Configuration doesn't have a valid JSON format.");
            }
        }
        return configurationMap;
    }

    @PUT
    @Path(value="{application}/flows/{flow}/trigger")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response triggerFlow(@PathParam(value="application") String appName, @PathParam(value="flow") String flowName) {
        if (!this.isEnabled()) {
            String response = this.buildErrorResponse(IllegalAccessException.class.toString(), ERROR_MESSAGE_HANLDER_DISABLED);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)response).build();
        }
        try {
            this.applicationService.triggerFlow(appName, flowName);
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        }
        catch (IllegalArgumentException e) {
            LOGGER.info(ERROR_TRIGGER_FLOW, (Object)flowName, (Object)appName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug((Object)e);
            String response = this.buildErrorResponse(e.getClass().toString(), e.getMessage());
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)response).build();
        }
    }

    private String buildErrorResponse(String type, String message) {
        return ErrorResponseBuilder.newInstance().addType(type).addMessage(message).build();
    }
}

