/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.suggester;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.yagi.framework.nodes.ArrayNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.ObjectNode;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.suggester.DefaultSuggestion;
import org.raml.yagi.framework.suggester.Suggestion;
import org.raml.yagi.framework.util.NodeSelector;

public class ReferenceSuggester {
    private String referenceKey;

    public ReferenceSuggester(String referenceKey) {
        this.referenceKey = referenceKey;
    }

    @Nonnull
    public List<Suggestion> getSuggestions(Node node) {
        ArrayList<Suggestion> result = new ArrayList<Suggestion>();
        Node contextNode = node.getRootNode();
        if (node instanceof StringNode) {
            String value = ((StringNode)node).getValue();
            String[] library = value.split("\\.");
            for (int i = 0; i < library.length - 1 && contextNode != null; ++i) {
                contextNode = NodeSelector.selectFrom((String)("uses/*/" + library[i]), (Node)contextNode);
            }
        }
        if (contextNode != null) {
            Node selectFrom = NodeSelector.selectFrom((String)this.referenceKey, (Node)contextNode);
            this.addSuggestions(result, selectFrom);
            Node libraries = NodeSelector.selectFrom((String)"uses", (Node)contextNode);
            this.addSuggestions(result, libraries);
        }
        return result;
    }

    private void addSuggestions(List<Suggestion> result, Node selectFrom) {
        if (selectFrom != null) {
            if (selectFrom instanceof ObjectNode) {
                this.collectSuggestions(result, selectFrom);
            } else if (selectFrom instanceof ArrayNode) {
                List children = selectFrom.getChildren();
                for (Node child : children) {
                    this.collectSuggestions(result, child);
                }
            }
        }
    }

    private void collectSuggestions(List<Suggestion> result, Node selectFrom) {
        List children = selectFrom.getChildren();
        for (Node child : children) {
            if (child.getChildren().isEmpty()) continue;
            String value = ((Node)child.getChildren().get(0)).toString();
            Node grandchild = (Node)child.getChildren().get(1);
            if (grandchild instanceof ArrayNode) {
                List referenceNodes = grandchild.getChildren();
                for (Node referenceNode : referenceNodes) {
                    this.collectReferenceNodeSuggestions(result, value, referenceNode);
                }
                continue;
            }
            this.collectReferenceNodeSuggestions(result, value, grandchild);
        }
    }

    private void collectReferenceNodeSuggestions(List<Suggestion> result, String value, Node grandchild) {
        Node description = NodeSelector.selectFrom((String)"usage", (Node)grandchild);
        String descriptionText = "";
        if (description != null) {
            descriptionText = description.toString();
        } else {
            Node usage = NodeSelector.selectFrom((String)"description", (Node)grandchild);
            if (usage != null) {
                descriptionText = usage.toString();
            }
        }
        result.add((Suggestion)new DefaultSuggestion(value, descriptionText, value));
    }
}

