/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.util.function.Consumer;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.func.CheckedConsumer;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.runtime.core.internal.event.NullEventFactory;
import org.mule.runtime.core.privileged.event.BaseEventContext;

public class FunctionalUtils
extends org.mule.runtime.api.util.FunctionalUtils {
    public static void safely(CheckedRunnable task) {
        FunctionalUtils.safely(task, e -> {});
    }

    public static void safely(CheckedRunnable task, Consumer<Exception> exceptionHandler) {
        try {
            task.run();
        }
        catch (Exception e) {
            exceptionHandler.accept(e);
        }
    }

    public static <T> void safely(T item, CheckedConsumer<T> task, Consumer<Exception> exceptionHandler) {
        try {
            task.accept(item);
        }
        catch (Exception e) {
            exceptionHandler.accept(e);
        }
    }

    public static <T> T withNullEvent(CheckedFunction<CoreEvent, T> function) {
        CoreEvent event = NullEventFactory.getNullEvent();
        try {
            T value = function.apply(event);
            ((BaseEventContext)event.getContext()).success();
            return value;
        }
        catch (RuntimeException e) {
            ((BaseEventContext)event.getContext()).error(e);
            throw e;
        }
    }
}

