/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.type.catalog;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.catalog.api.PrimitiveTypesTypeLoader;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.ArtifactTypeLoader;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.internal.type.catalog.SpecialTypesTypeLoader;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultArtifactTypeLoader
implements ArtifactTypeLoader,
Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultArtifactTypeLoader.class);
    private final TypeLoader primitivesTypeLoader = new PrimitiveTypesTypeLoader();
    private final TypeLoader specialTypesLoader = new SpecialTypesTypeLoader();
    private Map<String, Collection<ObjectType>> typesByExtension;
    private Map<String, Optional<MetadataType>> loadedTypes;
    @Inject
    private ExtensionManager extensionManager;
    private Collection<ExtensionModel> extensionModels;

    @Inject
    public DefaultArtifactTypeLoader(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public DefaultArtifactTypeLoader(Collection<ExtensionModel> extensionModels) {
        Objects.requireNonNull(extensionModels, "ExtensionModels collection cannot be null.");
        this.extensionModels = extensionModels;
    }

    public void initialise() throws InitialisationException {
        if (this.extensionModels == null && this.extensionManager != null) {
            this.extensionModels = this.extensionManager.getExtensions();
        }
        if (this.extensionModels == null) {
            this.extensionModels = Collections.emptySet();
            LOGGER.warn("DefaultArtifactTypeLoader has been initialized with a null Collection of ExtensionModels");
        }
        this.typesByExtension = new HashMap<String, Collection<ObjectType>>();
        this.loadedTypes = new ConcurrentHashMap<String, Optional<MetadataType>>();
        for (ExtensionModel extensionModel : this.extensionModels) {
            String extensionPrefix = extensionModel.getXmlDslModel().getPrefix();
            this.typesByExtension.put(extensionPrefix, extensionModel.getTypes());
        }
    }

    public Optional<MetadataType> load(String typeIdentifier) {
        return this.loadedTypes.computeIfAbsent(typeIdentifier, identifier -> this.doLoad((String)identifier));
    }

    private Optional<MetadataType> doLoad(String typeIdentifier) {
        return Optional.ofNullable(this.primitivesTypeLoader.load(typeIdentifier).orElseGet(() -> this.specialTypesLoader.load(typeIdentifier).orElseGet(() -> this.lookupType(typeIdentifier))));
    }

    private MetadataType lookupType(String typeIdentifier) {
        if (!typeIdentifier.contains(":")) {
            return null;
        }
        int separatorIndex = typeIdentifier.indexOf(":");
        String extensionIdentifier = typeIdentifier.substring(0, separatorIndex);
        String typeIdOrAlias = typeIdentifier.substring(separatorIndex + 1);
        if (this.typesByExtension.containsKey(extensionIdentifier)) {
            HashSet<MetadataType> typesWithTypeIdentifierAsAlias = new HashSet<MetadataType>();
            for (MetadataType metadataType2 : this.typesByExtension.get(extensionIdentifier)) {
                Optional extensionTypeTypeId = MetadataTypeUtils.getTypeId((MetadataType)metadataType2);
                if (extensionTypeTypeId.isPresent() && ((String)extensionTypeTypeId.get()).equals(typeIdOrAlias)) {
                    return metadataType2;
                }
                String extensionTypeAlias = ExtensionMetadataTypeUtils.getAlias((MetadataType)metadataType2);
                if (extensionTypeAlias == null || !extensionTypeAlias.equals(typeIdOrAlias)) continue;
                typesWithTypeIdentifierAsAlias.add(metadataType2);
            }
            if (typesWithTypeIdentifierAsAlias.size() == 1) {
                return (MetadataType)typesWithTypeIdentifierAsAlias.iterator().next();
            }
            if (typesWithTypeIdentifierAsAlias.size() > 1) {
                throw new IllegalArgumentException(String.format("No type with identifier [%s] and more that one with that alias. Use typeId to remove ambiguity [%s]", typeIdOrAlias, typesWithTypeIdentifierAsAlias.stream().map(metadataType -> MetadataTypeUtils.getTypeId((MetadataType)metadataType).orElse("")).collect(Collectors.joining(", "))));
            }
        }
        return null;
    }
}

