/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.processor.strategy.AbstractCachedThreadReactorSinkProvider;
import org.mule.runtime.core.internal.rx.FluxSinkRecorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.FluxSink;

public class DefaultCachedThreadReactorSinkProvider
extends AbstractCachedThreadReactorSinkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCachedThreadReactorSinkProvider.class);
    private final AtomicLong disposableSinks = new AtomicLong();
    private final Consumer<CoreEvent> eventConsumer;
    private final FlowConstruct flowConstruct;
    private final ReactiveProcessor processor;

    public DefaultCachedThreadReactorSinkProvider(FlowConstruct flowConstruct, ReactiveProcessor processor, Consumer<CoreEvent> eventConsumer) {
        this.flowConstruct = flowConstruct;
        this.processor = processor;
        this.eventConsumer = eventConsumer;
    }

    @Override
    public FluxSink<CoreEvent> createSink() {
        this.disposableSinks.incrementAndGet();
        FluxSinkRecorder recorder = new FluxSinkRecorder();
        recorder.flux().doOnNext(this.eventConsumer).transform((Function)this.processor).subscribe(null, e -> {
            LOGGER.error("Exception reached PS subscriber for flow '" + this.flowConstruct.getName() + "'", e);
            this.disposableSinks.decrementAndGet();
        }, this.disposableSinks::decrementAndGet);
        return recorder.getFluxSink();
    }

    @Override
    public void dispose() {
        super.dispose();
        long shutdownTimeout = this.flowConstruct.getMuleContext().getConfiguration().getShutdownTimeout();
        long startMillis = System.currentTimeMillis();
        while (this.disposableSinks.get() != 0L && System.currentTimeMillis() <= shutdownTimeout + startMillis && !Thread.currentThread().isInterrupted()) {
            Thread.yield();
        }
        if (Thread.currentThread().isInterrupted()) {
            if (System.getProperty("mule.lifecycle.failOnFirstDisposeError") != null) {
                throw new IllegalStateException(String.format("TX Subscribers of ProcessingStrategy for flow '%s' not completed before thread interruption", this.flowConstruct.getName()));
            }
            LOGGER.warn("TX Subscribers of ProcessingStrategy for flow '{}' not completed before thread interruption", (Object)this.flowConstruct.getName());
            this.invalidateAll();
        } else if (this.disposableSinks.get() != 0L) {
            if (System.getProperty("mule.lifecycle.failOnFirstDisposeError") != null) {
                throw new IllegalStateException(String.format("TX Subscribers of ProcessingStrategy for flow '%s' not completed in %d ms", this.flowConstruct.getName(), shutdownTimeout));
            }
            LOGGER.warn("TX Subscribers of ProcessingStrategy for flow '{}' not completed in {} ms", (Object)this.flowConstruct.getName(), (Object)shutdownTimeout);
            this.invalidateAll();
        }
    }
}

