/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.retry.policy.NoRetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.internal.connection.ConnectionHandlerAdapter;
import org.mule.runtime.core.internal.connection.ConnectionManagementStrategy;
import org.mule.runtime.core.internal.connection.ConnectionManagementStrategyFactory;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.connection.ConnectionProviderWrapper;
import org.mule.runtime.core.internal.connection.DefaultConnectionProviderWrapper;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultConnectionManager
implements ConnectionManagerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConnectionManager.class);
    private final Map<Reference<Object>, ConnectionManagementStrategy> connections = new HashMap<Reference<Object>, ConnectionManagementStrategy>();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final MuleContext muleContext;
    private final RetryPolicyTemplate retryPolicyTemplate;
    private final PoolingProfile defaultPoolingProfile;
    private final ConnectionManagementStrategyFactory managementStrategyFactory;
    private final ReconnectionConfig defaultReconnectionConfig = ReconnectionConfig.getDefault();

    @Inject
    public DefaultConnectionManager(MuleContext muleContext) {
        this.muleContext = muleContext;
        this.defaultPoolingProfile = new PoolingProfile();
        this.retryPolicyTemplate = new NoRetryPolicyTemplate();
        this.managementStrategyFactory = new ConnectionManagementStrategyFactory(this.defaultPoolingProfile, muleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <C> void bind(Object owner, ConnectionProvider<C> connectionProvider) {
        ConnectionManagementStrategy<C> previous;
        LifecycleUtils.assertNotStopping(this.muleContext, "Mule is shutting down... cannot bind new connections");
        connectionProvider = new DefaultConnectionProviderWrapper<C>(connectionProvider, this.muleContext);
        ConnectionManagementStrategy<C> managementStrategy = this.managementStrategyFactory.getStrategy(connectionProvider);
        this.writeLock.lock();
        try {
            previous = this.connections.put((Reference<Object>)new Reference(owner), managementStrategy);
        }
        finally {
            this.writeLock.unlock();
        }
        if (previous != null) {
            this.close(previous);
        }
    }

    @Override
    public <C> RetryPolicyTemplate getRetryTemplateFor(ConnectionProvider<C> connectionProvider) {
        return connectionProvider instanceof ConnectionProviderWrapper ? ((ConnectionProviderWrapper)connectionProvider).getRetryPolicyTemplate() : this.defaultReconnectionConfig.getRetryPolicyTemplate();
    }

    @Override
    public <C> ReconnectionConfig getReconnectionConfigFor(ConnectionProvider<C> connectionProvider) {
        return connectionProvider instanceof ConnectionProviderWrapper ? ((ConnectionProviderWrapper)connectionProvider).getReconnectionConfig().orElse(this.defaultReconnectionConfig) : this.defaultReconnectionConfig;
    }

    @Override
    public <C> ConnectionValidationResult testConnectivity(ConnectionProvider<C> connectionProvider) {
        return this.doTestConnectivity(() -> {
            try {
                return this.doTestConnectivity(connectionProvider, this.managementStrategyFactory.getStrategy(connectionProvider).getConnectionHandler());
            }
            catch (ConnectionException e) {
                return ConnectionValidationResult.failure((String)e.getMessage(), (ErrorType)e.getErrorType().orElse(null), (Exception)((Object)e));
            }
        });
    }

    @Override
    public <C> ConnectionValidationResult testConnectivity(C connection, ConnectionHandler<C> connectionHandler) {
        if (!(connectionHandler instanceof ConnectionHandlerAdapter)) {
            throw new IllegalArgumentException("ConnectionHandler was not produced through this manager");
        }
        return ((ConnectionHandlerAdapter)connectionHandler).getConnectionProvider().validate(connection);
    }

    @Override
    public ConnectionValidationResult testConnectivity(ConfigurationInstance configurationInstance) throws IllegalArgumentException {
        if (!configurationInstance.getConnectionProvider().isPresent()) {
            throw new IllegalArgumentException("The component does not support connectivity testing");
        }
        return this.doTestConnectivity(() -> {
            ConnectionHandler connectionHandler;
            ConnectionProvider connectionProvider = (ConnectionProvider)configurationInstance.getConnectionProvider().get();
            Object config = configurationInstance.getValue();
            try {
                this.readLock.lock();
                try {
                    connectionHandler = this.hasBinding(config) ? this.getConnection(config) : this.managementStrategyFactory.getStrategy(connectionProvider).getConnectionHandler();
                }
                finally {
                    this.readLock.unlock();
                }
            }
            catch (ConnectionException e) {
                return ConnectionValidationResult.failure((String)e.getMessage(), (ErrorType)e.getErrorType().orElse(null), (Exception)((Object)e));
            }
            return this.doTestConnectivity(connectionProvider, connectionHandler);
        });
    }

    private ConnectionValidationResult doTestConnectivity(Callable<ConnectionValidationResult> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            return ConnectionValidationResult.failure((String)"Exception was found trying to test connectivity", (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <C> ConnectionValidationResult doTestConnectivity(ConnectionProvider<C> connectionProvider, ConnectionHandler<C> connectionHandler) throws Exception {
        try {
            ConnectionValidationResult connectionValidationResult = connectionProvider.validate(connectionHandler.getConnection());
            return connectionValidationResult;
        }
        catch (ConnectionException e) {
            ConnectionValidationResult connectionValidationResult = ConnectionValidationResult.failure((String)e.getMessage(), (ErrorType)e.getErrorType().orElse(null), (Exception)((Object)e));
            return connectionValidationResult;
        }
        finally {
            if (connectionHandler != null) {
                connectionHandler.release();
            }
        }
    }

    @Override
    public boolean hasBinding(Object config) {
        return this.connections.containsKey(new Reference(config));
    }

    @Override
    public void unbind(Object config) {
        ConnectionManagementStrategy managementStrategy;
        this.writeLock.lock();
        try {
            managementStrategy = this.connections.remove(new Reference(config));
        }
        finally {
            this.writeLock.unlock();
        }
        if (managementStrategy != null) {
            this.close(managementStrategy);
        }
    }

    @Override
    public <C> ConnectionHandler<C> getConnection(Object config) throws ConnectionException {
        ConnectionManagementStrategy handlingStrategy = null;
        this.readLock.lock();
        try {
            handlingStrategy = this.connections.get(new Reference(config));
        }
        finally {
            this.readLock.unlock();
        }
        if (handlingStrategy == null) {
            throw new ConnectionException("No ConnectionProvider has been registered for owner " + config);
        }
        return handlingStrategy.getConnectionHandler();
    }

    public void stop() throws MuleException {
        this.writeLock.lock();
        try {
            this.connections.values().stream().forEach(this::close);
            this.connections.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void close(ConnectionManagementStrategy managementStrategy) {
        try {
            managementStrategy.close();
        }
        catch (Exception e) {
            LOGGER.warn("An error was found trying to release connections", (Throwable)e);
        }
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.retryPolicyTemplate, LOGGER);
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.retryPolicyTemplate, true, this.muleContext);
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.retryPolicyTemplate);
    }

    @Override
    public PoolingProfile getDefaultPoolingProfile() {
        return this.defaultPoolingProfile;
    }
}

