/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.tracing.customization;

import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;

public class SpanInitialInfoUtils {
    private static final String CORE_EVENT_SPAN_NAME_SEPARATOR = ":";
    public static final String UNKNOWN = "unknown";

    public static String getSpanName(ComponentIdentifier componentIdentifier) {
        return SpanInitialInfoUtils.getUnknownIfEmptyNamespace(componentIdentifier) + CORE_EVENT_SPAN_NAME_SEPARATOR + SpanInitialInfoUtils.getUnknownIfEmptyName(componentIdentifier);
    }

    private static String getUnknownIfEmptyName(ComponentIdentifier componentIdentifier) {
        if (componentIdentifier == null) {
            return UNKNOWN;
        }
        return componentIdentifier.getName();
    }

    private static String getUnknownIfEmptyNamespace(ComponentIdentifier componentIdentifier) {
        if (componentIdentifier == null) {
            return UNKNOWN;
        }
        return componentIdentifier.getNamespace();
    }

    public static String getLocationAsString(ComponentLocation componentLocation) {
        if (componentLocation != null) {
            return componentLocation.getLocation();
        }
        return UNKNOWN;
    }
}

