/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.api.contract.tier;

import com.mulesoft.mule.runtime.gw.api.contract.tier.Tier;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Parameter;

@Alias(value="tier")
public class SingleTier
implements Tier,
Serializable {
    private static final long serialVersionUID = 3180085812900378840L;
    @Parameter
    private Integer maximumRequestsPerPeriod;
    @Parameter
    private Long timePeriodMillis;

    public SingleTier() {
    }

    public SingleTier(Integer maximumRequestsPerPeriod, Long timePeriodMillis) {
        this.maximumRequestsPerPeriod = maximumRequestsPerPeriod;
        this.timePeriodMillis = timePeriodMillis;
    }

    public Period period() {
        return Period.millis(this.timePeriodMillis);
    }

    public long requests() {
        return this.maximumRequestsPerPeriod.intValue();
    }

    @Override
    public List<SingleTier> flattened() {
        return Arrays.asList(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SingleTier)) {
            return false;
        }
        SingleTier tier = (SingleTier)o;
        if (!this.maximumRequestsPerPeriod.equals(tier.maximumRequestsPerPeriod)) {
            return false;
        }
        return this.timePeriodMillis.equals(tier.timePeriodMillis);
    }

    public int hashCode() {
        int result = this.maximumRequestsPerPeriod.hashCode();
        result = 31 * result + this.timePeriodMillis.hashCode();
        return result;
    }

    public String toString() {
        return "SingleTier{maximumRequestsPerPeriod=" + this.maximumRequestsPerPeriod + ", timePeriodMillis=" + this.timePeriodMillis + '}';
    }
}

