/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.util;

import com.mulesoft.mule.runtime.module.batch.BatchProcessingListener;
import com.mulesoft.mule.runtime.module.batch.BatchProperties;
import com.mulesoft.mule.runtime.module.batch.api.BatchJobInstance;
import com.mulesoft.mule.runtime.module.batch.api.BatchStep;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContext;
import com.mulesoft.mule.runtime.module.batch.exception.BatchException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.transaction.xa.ResourceManagerException;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BatchUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchUtils.class);

    public static Record getRecord(CoreEvent event) {
        Object payload = CoreEvent.getVariableValueOrNull((String)"_mule_batch_INTERNAL_record", (CoreEvent)event);
        if (payload instanceof Record) {
            return (Record)payload;
        }
        payload = event.getMessage().getPayload().getValue();
        if (payload instanceof Record) {
            return (Record)payload;
        }
        throw BatchUtils.noRecordException();
    }

    public static Record getRecord(BindingContext bindingContext) {
        Optional<Map<String, TypedValue>> vars = BatchUtils.lookup("vars", bindingContext);
        Optional record = BatchUtils.getVariable("_mule_batch_INTERNAL_record", vars);
        if (!record.isPresent()) {
            record = BatchUtils.lookup("payload", bindingContext);
        }
        return (Record)record.orElseThrow(() -> BatchUtils.noRecordException());
    }

    private static <T> Optional<T> getVariable(String name, Optional<Map<String, TypedValue>> vars) {
        if (vars.isPresent() && vars.get().containsKey(name)) {
            return Optional.of(vars.get().get(name).getValue());
        }
        return Optional.empty();
    }

    private static RuntimeException noRecordException() {
        return new IllegalStateException("No record available in context. recordVars() function can only be used inside a batch step.");
    }

    private static <T> Optional<T> lookup(String key, BindingContext bindingContext) {
        return bindingContext.lookup(key).map(TypedValue::getValue);
    }

    public static BatchException toBatchException(Exception e, BatchJobInstanceAdapter jobInstance) {
        if (e instanceof BatchException) {
            return (BatchException)((Object)e);
        }
        return new BatchException(e, (BatchJobInstance)jobInstance);
    }

    public static Record toRecord(CoreEvent event, Object object) {
        Record record;
        if (object instanceof Message) {
            Message message = (Message)object;
            record = new Record((TypedValue<Object>)message.getPayload(), (TypedValue<Object>)message.getAttributes());
        } else {
            record = object instanceof TypedValue ? new Record((TypedValue<Object>)((TypedValue)object)) : new Record((TypedValue<Object>)TypedValue.of((Object)object));
        }
        record.replaceVariables(event.getVariables());
        BatchProperties.ALL_INTERNAL_VARS.forEach(record::removeVariable);
        return record;
    }

    public static String buildExceptionLogMessage(BatchJobInstance jobInstance, BatchStep step, Exception exception) {
        StringBuilder builder = new StringBuilder();
        builder.append("Found exception processing record on step '").append(step.getName()).append("' for job instance '").append(jobInstance.getId()).append("' of job '").append(jobInstance.getOwnerJobName()).append("'.\nThis is the first record to show this exception on this step for this job instance. Subsequent records with the same failures").append("will not be logged for performance and log readability reasons:").append(System.lineSeparator());
        MuleException muleException = ExceptionHelper.getRootMuleException((Throwable)exception);
        if (muleException != null) {
            builder.append(muleException.getDetailedMessage());
        } else {
            builder.append(exception.getMessage()).append(System.lineSeparator());
            builder.append(ExceptionUtils.getFullStackTraceWithoutMessages((Throwable)exception));
        }
        return builder.toString();
    }

    public static void commit(BatchTransactionContext ctx) {
        try {
            ctx.commit();
        }
        catch (ResourceManagerException e) {
            BatchUtils.logResourceException(ctx, "commit", (Exception)((Object)e));
            BatchUtils.rollback(ctx);
        }
    }

    public static void singleAckAndCommitIfNecessary(BatchTransactionContext ctx) {
        ctx.ackSingleRecordProcessed();
        if (ctx.isBlockCompleted()) {
            BatchUtils.commit(ctx);
        }
    }

    public static void rollback(BatchTransactionContext ctx) {
        try {
            ctx.rollback();
        }
        catch (ResourceManagerException e) {
            BatchUtils.logResourceException(ctx, "rollback", (Exception)((Object)e));
        }
    }

    public static void completeWorkOnBlock(List<Record> block, boolean shouldRollback, BatchProcessingListener listener, BatchTransactionContext ctx) {
        if (block != null) {
            block.forEach(record -> {
                if (record.getCompletionCallback() != null) {
                    record.getCompletionCallback().decrementConsumers();
                }
            });
        }
        if (shouldRollback) {
            try {
                BatchUtils.rollback(ctx);
            }
            finally {
                if (listener != null && !CollectionUtils.isEmpty(block)) {
                    listener.onSteppingQueueDispatch(ctx.getJobInstance(), block);
                }
            }
        }
    }

    private static void logResourceException(BatchTransactionContext ctx, String operation, Exception e) {
        LOGGER.error(String.format("Could not %s transaction for processing block '%s' processing instance '%s' of job '%s'", operation, ctx.getId(), ctx.getJobInstance().getId(), ctx.getJobInstance().getOwnerJobName()), (Throwable)e);
    }
}

