/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.Objects;
import org.everit.json.schema.StringSchema;
import org.everit.json.schema.loader.LoadingState;

public class StringSchemaLoader {
    private LoadingState ls;

    public StringSchemaLoader(LoadingState ls) {
        this.ls = Objects.requireNonNull(ls, "ls cannot be null");
    }

    public StringSchema.Builder load() {
        StringSchema.Builder builder = StringSchema.builder();
        this.ls.ifPresent("minLength", Integer.class, builder::minLength);
        this.ls.ifPresent("maxLength", Integer.class, builder::maxLength);
        this.ls.ifPresent("pattern", String.class, builder::pattern);
        this.ls.ifPresent("format", String.class, format -> this.addFormatValidator(builder, (String)format));
        return builder;
    }

    private void addFormatValidator(StringSchema.Builder builder, String formatName) {
        this.ls.getFormatValidator(formatName).ifPresent(builder::formatValidator);
    }
}

