/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe.internal;

import java.time.Duration;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.internal.CircuitState;

public class OpenState
extends CircuitState {
    private final CircuitBreaker breaker;
    private final long startTime = System.nanoTime();
    private final long delayNanos;

    public OpenState(CircuitBreaker breaker, CircuitState previousState, Duration delay) {
        this.breaker = breaker;
        this.bitSet = previousState.bitSet;
        this.delayNanos = delay.toNanos();
    }

    @Override
    public boolean allowsExecution() {
        if (System.nanoTime() - this.startTime >= this.delayNanos) {
            this.breaker.halfOpen();
            return true;
        }
        return false;
    }

    @Override
    public CircuitBreaker.State getInternals() {
        return CircuitBreaker.State.OPEN;
    }
}

