/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.api.properties;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.config.DefaultConfigurationProperty;
import org.mule.runtime.core.privileged.execution.LocationExecutionContextProvider;
import org.mule.runtime.properties.api.ConfigurationPropertiesProvider;
import org.mule.runtime.properties.api.ConfigurationPropertiesProviderFactory;
import org.mule.runtime.properties.api.ConfigurationProperty;
import org.mule.runtime.properties.api.ResourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesResolverUtils {
    public static final String GLOBAL_PROPERTY = "global-property";
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesResolverUtils.class);

    private PropertiesResolverUtils() {
    }

    public static Supplier<Map<String, ConfigurationProperty>> createGlobalPropertiesSupplier(ArtifactAst artifactAst) {
        return new LazyValue(() -> {
            HashMap globalProperties = new HashMap();
            artifactAst.topLevelComponentsStream().filter(comp -> GLOBAL_PROPERTY.equals(comp.getIdentifier().getName())).forEach(comp -> {
                String key = comp.getParameter("General", "name").getResolvedRawValue();
                String rawValue = comp.getParameter("General", "value").getRawValue();
                globalProperties.put(key, new DefaultConfigurationProperty(String.format("global-property - file: %s - lineNumber %s", comp.getMetadata().getFileName().orElse("(n/a)"), comp.getMetadata().getStartLine().orElse(-1)), key, rawValue));
            });
            return globalProperties;
        });
    }

    public static List<ConfigurationPropertiesProvider> getConfigurationPropertiesProvidersFromComponents(ArtifactAst artifactAst, ResourceProvider externalResourceProvider, ConfigurationPropertiesResolver localResolver) {
        Map<ComponentIdentifier, ConfigurationPropertiesProviderFactory> providerFactoriesMap = PropertiesResolverUtils.loadProviderFactories();
        return artifactAst.topLevelComponentsStream().filter(comp -> providerFactoriesMap.containsKey(comp.getIdentifier())).map(comp -> {
            ConfigurationPropertiesProvider provider = ((ConfigurationPropertiesProviderFactory)providerFactoriesMap.get(comp.getIdentifier())).createProvider(comp, (UnaryOperator)localResolver, externalResourceProvider);
            if (provider instanceof Component) {
                HashMap<QName, Object> annotations = new HashMap<QName, Object>();
                annotations.put(AbstractComponent.LOCATION_KEY, comp.getLocation());
                annotations.put(AbstractComponent.ANNOTATION_NAME, comp.getIdentifier());
                annotations.put(Component.Annotations.SOURCE_ELEMENT_ANNOTATION_KEY, comp.getMetadata().getSourceCode().map(LocationExecutionContextProvider::maskPasswords).orElse(null));
                ((Component)provider).setAnnotations(annotations);
            }
            return provider;
        }).collect(Collectors.toList());
    }

    public static Map<ComponentIdentifier, ConfigurationPropertiesProviderFactory> loadProviderFactories() {
        HashMap<ComponentIdentifier, ConfigurationPropertiesProviderFactory> providerFactoriesMap = new HashMap<ComponentIdentifier, ConfigurationPropertiesProviderFactory>();
        ServiceLoader<ConfigurationPropertiesProviderFactory> providerFactories = ServiceLoader.load(ConfigurationPropertiesProviderFactory.class);
        providerFactories.forEach(service -> {
            ComponentIdentifier componentIdentifier = service.getSupportedComponentIdentifier();
            if (providerFactoriesMap.containsKey(componentIdentifier)) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Multiple configuration providers for component: " + componentIdentifier)));
            }
            providerFactoriesMap.put(componentIdentifier, (ConfigurationPropertiesProviderFactory)service);
        });
        try {
            Class<?> providerFactoryIfaceOld = Class.forName("org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProviderFactory");
            ServiceLoader<?> providerFactoriesOld = ServiceLoader.load(providerFactoryIfaceOld);
            providerFactoriesOld.forEach(service -> {
                ComponentIdentifier componentIdentifier = service.getSupportedComponentIdentifier();
                if (providerFactoriesMap.containsKey(componentIdentifier)) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Multiple configuration providers for component: " + componentIdentifier)));
                }
                providerFactoriesMap.put(componentIdentifier, (ConfigurationPropertiesProviderFactory)service);
            });
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("Interface 'org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProviderFactory' not available in classpath, skipping its processing.");
        }
        return providerFactoriesMap;
    }
}

