/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.XQueryParser;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class QNameParser {
    private NamespaceResolver resolver;
    private boolean acceptEQName = false;
    private String errorOnBadSyntax = "XPST0003";
    private String errorOnUnresolvedPrefix = "XPST0081";
    private XQueryParser.Unescaper unescaper = null;

    public QNameParser(NamespaceResolver resolver) {
        this.resolver = resolver;
    }

    public void setNamespaceResolver(NamespaceResolver resolver) {
        this.resolver = resolver;
    }

    public void setAcceptEQName(boolean acceptEQName) {
        this.acceptEQName = acceptEQName;
    }

    public void setUnescaper(XQueryParser.Unescaper unescaper) {
        this.unescaper = unescaper;
    }

    public void setErrorOnBadSyntax(String code) {
        this.errorOnBadSyntax = code;
    }

    public void setErrorOnUnresolvedPrefix(String code) {
        this.errorOnUnresolvedPrefix = code;
    }

    public StructuredQName parse(CharSequence lexicalName, String defaultNS) throws XPathException {
        lexicalName = Whitespace.trimWhitespace(lexicalName);
        if (this.acceptEQName && lexicalName.length() >= 4 && lexicalName.charAt(0) == 'Q' && lexicalName.charAt(1) == '{') {
            String name = lexicalName.toString();
            int endBrace = name.indexOf(125);
            if (endBrace < 0) {
                throw new XPathException("Invalid EQName: closing brace not found", this.errorOnBadSyntax);
            }
            if (endBrace == name.length() - 1) {
                throw new XPathException("Invalid EQName: local part is missing", this.errorOnBadSyntax);
            }
            String uri = name.substring(2, endBrace).toString();
            if (this.unescaper != null && uri.contains("&")) {
                uri = this.unescaper.unescape(uri).toString();
            }
            if (uri.equals("http://www.w3.org/2000/xmlns/")) {
                throw new XPathException("The string 'http://www.w3.org/2000/xmlns/' cannot be used as a namespace URI", "XQST0070");
            }
            String local = name.substring(endBrace + 1);
            this.checkLocalName(local);
            return new StructuredQName("", uri, local);
        }
        try {
            String[] parts = NameChecker.getQNameParts(lexicalName);
            this.checkLocalName(parts[1]);
            if (parts[0].isEmpty()) {
                return new StructuredQName("", defaultNS, parts[1]);
            }
            String uri = this.resolver.getURIForPrefix(parts[0], false);
            if (uri == null) {
                throw new XPathException("Namespace prefix '" + parts[0] + "' has not been declared", this.errorOnUnresolvedPrefix);
            }
            return new StructuredQName(parts[0], uri, parts[1]);
        }
        catch (QNameException e) {
            throw new XPathException(e.getMessage(), this.errorOnBadSyntax);
        }
    }

    private void checkLocalName(String local) throws XPathException {
        if (!NameChecker.isValidNCName(local)) {
            throw new XPathException("Invalid EQName: local part is not a valid NCName", this.errorOnBadSyntax);
        }
    }
}

