/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.span.command;

import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.tracer.api.context.SpanContext;
import org.mule.runtime.tracer.api.span.InternalSpan;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.mule.runtime.tracer.api.span.validation.Assertion;
import org.mule.runtime.tracer.impl.span.command.AbstractFailsafeSpanInternalSpanCommand;
import org.mule.runtime.tracer.impl.span.command.spancontext.SpanContextFromEventContextGetter;
import org.mule.runtime.tracer.impl.span.factory.EventSpanFactory;

public class EventContextStartSpanCommand
extends AbstractFailsafeSpanInternalSpanCommand {
    public static final String ERROR_MESSAGE = "Error starting a span";
    private final EventContext eventContext;
    private final Assertion assertion;
    private final EventSpanFactory eventSpanFactory;
    private final InitialSpanInfo initialSpaninfo;

    public static EventContextStartSpanCommand getEventContextStartSpanCommandFrom(EventContext eventContext, EventSpanFactory eventSpanFactory, InitialSpanInfo initialSpanInfo, Assertion assertion) {
        return new EventContextStartSpanCommand(eventContext, eventSpanFactory, initialSpanInfo, assertion);
    }

    private EventContextStartSpanCommand(EventContext eventContext, EventSpanFactory eventSpanFactory, InitialSpanInfo initialSpanInfo, Assertion assertion) {
        this.eventSpanFactory = eventSpanFactory;
        this.eventContext = eventContext;
        this.assertion = assertion;
        this.initialSpaninfo = initialSpanInfo;
    }

    @Override
    protected Supplier<Optional<InternalSpan>> getSupplier() {
        return () -> {
            SpanContext spanContext = SpanContextFromEventContextGetter.getSpanContextFromEventContextGetter().get(this.eventContext);
            InternalSpan newSpan = null;
            if (spanContext != null) {
                newSpan = this.eventSpanFactory.getSpan(spanContext, this.initialSpaninfo);
                spanContext.setSpan(newSpan, this.assertion);
            }
            return Optional.ofNullable(newSpan);
        };
    }

    @Override
    protected String getErrorMessage() {
        return ERROR_MESSAGE;
    }
}

