/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.exporter.optel.span.provider;

import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapGetter;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.mule.runtime.api.profiling.tracing.Span;
import org.mule.runtime.tracer.api.span.InternalSpan;
import org.mule.runtime.tracer.api.span.exporter.SpanExporter;
import org.mule.runtime.tracer.api.span.info.InitialExportInfo;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.mule.runtime.tracer.exporter.api.config.SpanExporterConfiguration;
import org.mule.runtime.tracer.impl.exporter.DecoratedMuleOpenTelemetrySpan;
import org.mule.runtime.tracer.impl.exporter.OpenTelemetrySpanExporter;
import org.mule.runtime.tracer.impl.exporter.config.SpanExporterConfigurationDiscoverer;
import org.mule.runtime.tracer.impl.exporter.optel.resources.OpenTelemetryResources;
import org.mule.runtime.tracer.impl.exporter.optel.resources.SpanExporterConfiguratorException;
import org.mule.runtime.tracer.impl.exporter.optel.span.MuleOpenTelemetrySpan;
import org.mule.runtime.tracer.impl.exporter.optel.span.NoopMuleOpenTelemetrySpan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleOpenTelemetrySpanProvider {
    private static final SpanExporterConfiguration CONFIGURATION = SpanExporterConfigurationDiscoverer.discoverSpanExporterConfiguration();
    private static final TextMapGetter<Map<String, String>> OPEN_TELEMETRY_SPAN_GETTER = new MuleOpenTelemetryRemoteContextGetter();
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleOpenTelemetrySpanProvider.class);

    private MuleOpenTelemetrySpanProvider() {
    }

    public static MuleOpenTelemetrySpan getNewOpenTelemetrySpan(InternalSpan internalSpan, InitialSpanInfo initialSpanInfo, String serviceName) {
        InitialExportInfo initialExportInfo = initialSpanInfo.getInitialExportInfo();
        if (!initialExportInfo.isExportable()) {
            return MuleOpenTelemetrySpanProvider.getNonExportableSpan(internalSpan);
        }
        try {
            return MuleOpenTelemetrySpanProvider.getExportableSpan(internalSpan, initialExportInfo, serviceName, initialSpanInfo.isPolicySpan(), initialSpanInfo.isRootSpan());
        }
        catch (SpanExporterConfiguratorException e) {
            LOGGER.warn("Exception on generating exporter for open telemetry traces", (Throwable)e);
            return MuleOpenTelemetrySpanProvider.getNonExportableSpan(internalSpan);
        }
    }

    private static MuleOpenTelemetrySpan getExportableSpan(InternalSpan internalSpan, InitialExportInfo initialExportInfo, String serviceName, boolean isPolicy, boolean isRoot) throws SpanExporterConfiguratorException {
        SpanBuilder spanBuilder = OpenTelemetryResources.getTracer(CONFIGURATION, serviceName).spanBuilder(internalSpan.getName()).setStartTimestamp(internalSpan.getDuration().getStart().longValue(), TimeUnit.NANOSECONDS);
        InternalSpan parentSpan = InternalSpan.getAsInternalSpan((Span)internalSpan.getParent());
        if (parentSpan != null) {
            SpanExporter spanExporter = parentSpan.getSpanExporter();
            if (spanExporter instanceof OpenTelemetrySpanExporter) {
                spanBuilder.setParent(Context.current().with((ImplicitContextKeyed)((OpenTelemetrySpanExporter)spanExporter).getOpenTelemetrySpan()));
            } else {
                spanBuilder.setParent(OpenTelemetryResources.getPropagator().getTextMapPropagator().extract(Context.current(), (Object)parentSpan.serializeAsMap(), OPEN_TELEMETRY_SPAN_GETTER));
            }
        }
        DecoratedMuleOpenTelemetrySpan decoratedMuleOpenTelemetrySpan = new DecoratedMuleOpenTelemetrySpan(spanBuilder.startSpan());
        decoratedMuleOpenTelemetrySpan.setNoExportUntil(initialExportInfo.noExportUntil());
        decoratedMuleOpenTelemetrySpan.setRoot(isRoot);
        decoratedMuleOpenTelemetrySpan.setPolicy(isPolicy);
        return decoratedMuleOpenTelemetrySpan;
    }

    private static MuleOpenTelemetrySpan getNonExportableSpan(InternalSpan internalSpan) {
        SpanExporter parentSpanSpanExporter;
        InternalSpan parentSpan = InternalSpan.getAsInternalSpan((Span)internalSpan.getParent());
        if (parentSpan != null && (parentSpanSpanExporter = parentSpan.getSpanExporter()) instanceof OpenTelemetrySpanExporter) {
            return new NoopMuleOpenTelemetrySpan(((OpenTelemetrySpanExporter)parentSpanSpanExporter).getOpenTelemetrySpan());
        }
        return new NoopMuleOpenTelemetrySpan();
    }

    private static class MuleOpenTelemetryRemoteContextGetter
    implements TextMapGetter<Map<String, String>> {
        private MuleOpenTelemetryRemoteContextGetter() {
        }

        public Iterable<String> keys(Map<String, String> stringStringMap) {
            return stringStringMap.keySet();
        }

        @Nullable
        public String get(@Nullable Map<String, String> stringStringMap, @Nullable String key) {
            if (stringStringMap == null) {
                return null;
            }
            return stringStringMap.get(key);
        }
    }
}

